---
title: "Universal Feed API"
order: 8
---

Like the package format, the Universal Feed API was designed with simplicity in mind. Because universal packages are designed to be consumed by any language or platform, the API offers several different ways to do the same thing, as some operations are much more difficult in some languages than others.

The API consists of a few different URL endpoints, accessible over HTTP/S. If configured, they can be secured using Integrated Windows Authentication or Basic Authentication using whatever granular feed- or system-level privileges needed.

In ProGet, all endpoints are prefixed with `/upack/«feed-name»`:

Package Endpoints:
* [List Universal Packages](/docs/proget/upack/proget-api-universalfeed/proget-api-universalfeed-list) - describes specified packages
* [Upload Universal Package](/docs/proget/upack/proget-api-universalfeed/proget-api-universalfeed-upload) - uploads a specified package
* [Delete Universal Package](/docs/proget/upack/proget-api-universalfeed/proget-api-universalfeed-delete) - deletes a specified package
* [Download Universal Package](/docs/proget/upack/proget-api-universalfeed/proget-api-universalfeed-download) - downloads a specified package
* [Download Virtual Package](/docs/proget/upack/proget-api-universalfeed/proget-api-universalfeed-download-vpack) - downloads a specified virtual package
* [Import Universal Package](/docs/proget/upack/proget-api-universalfeed/proget-api-universalfeed-import) - imports a package from specified source

Other Endpoints:
* [Download Universal Package File](/docs/proget/upack/proget-api-universalfeed/proget-api-universalfeed-download-file) - downloads a specified file within a package
* [Universal Feed Metadata](/docs/proget/upack/proget-api-universalfeed/proget-api-universalfeed-metadata) - describes a specified feed
* [List Universal Package Versions](/docs/proget/upack/proget-api-universalfeed/proget-api-universalfeed-version) - describes versions of specified packages

Unsupported Endpoints:
* [Search Packages (_Unsupported_)](/docs/proget/upack/proget-api-universalfeed/proget-api-universalfeed-search) - describes a list of packages

Note that the endpoint prefix itself is not a valid API endpoint, and may return a `404` error, or simply redirect you to this page.

Currently, the API only returns results in JSON format with a standard, `200` (success) status code unless there's an error; future versions (if anyone requests it) may add additional formats, such as XML, which would be specified using a `Content-Type` request headers and/or an alternate querystring parameter.

All searching and matching is case insensitive. This will most certainly never change, as it's either a mistake or a bad practice to have different packages named `SomeThing` and `someThing`.

<h2 id="authentication">Authenticating to Asset Directory API Endpoints</h2>

The following is a summary of access types and their corresponding requirements for various API keys types and endpoints within this API.

| Access Type | Requirements |
| --- | --- |
| System API Keys | `Use/Manage Feeds`  
| Feed API Keys | `View/Download` is required for all endpoints<br/>`Add/Repackage` is required for uploading/importing endpoints<br/>`Overwrite/Delete` is required for deletion endpoints
| Personal API Key | `Feeds_ViewFeed` is required for all endpoints<br/>`Feeds_AddPackage` is required for uploading/importing endpoints<br/>`Feeds_DeletePackage` is required for deletion endpoints
| No API Key | anonymous or authenticated user must have at least `Feeds_ViewFeed`

To specify an API Key, use the request header (`X-ApiKey`), querystring (`key`), or `api:«api-key»` as the username. See [API Key Usage](/docs/proget/reference-api/proget-apikeys#using-api-keys) to learn more.

:::(Info) (🚀 Quick Example: Authenticating with curl)
For example, to authenticate with the API key `abc12345` to the "Feed Metadata" endpoint, you could specify the API key as follows:
````
curl -X GET --header "X-ApiKey: abc12345" "https://proget.corp.local/upack/MyUniversalFeed/meta"
````
:::

<h2 id="data-specifications">Data Specifications</h2>

<h3 id="feed-metadata">FeedMetadata Object Attributes</h3>

`FeedMetadata` is a set of key/value pairs that correspond to the metadata fields in a Universal Feed. It's used as output data for the [Feed Metadata](/docs/proget/upack/proget-api-universalfeed/proget-api-universalfeed-metadata)
 Endpoint as a JSON-formatted object.

| Property | Format| Notes|
|---|---|---|
| `apiVersion` | string | contains the supported Universal Feed Version.|
| `name` | string | contains the name of the feed. |
| `description` | string | contains the description of the feed. |
| `version` | string | contains the Universal Feed API version of the feed. |
| `packageCount` | int | contains the number of unique package names in the feed. |
| `packageVersionCount` | int | contains the number of packages in the feed. |
| `services` | array | array of strings containing any of the following values:<br> - `VirtualPackages`: Supports virtual packages, and injects the `isVirtual` property in the list endpoints.<br> - `RemotePackages`: Supports remote packages (e.g., connectors in ProGet), and injects the `isLocal` and `isCached` properties in the list endpoints.<br> - `UploadPackage`: Supports simple uploading (a complete package file only).<br> - `UploadContents`: Supports partial uploading (contents, metadata, etc).<br> - `Delete`: Supports deleting packages <br> - `DownloadContents`: Supports downloading of individual files or `contentOnly` of a package. |

#### JSON Object

```json
{
  "apiVersion": "1.3.0",
  "name": "myUniversalFeed",
  "description": "A Universal Feed",
  "packageCount": 4,
  "packageVersionCount": 5,
  "services": [
    "VirtualPackages",
    "RemotePackages",
    "UploadPackage",
    "UploadContents",
    "Delete",
    "DownloadContents"
  ]
}
```

<h3 id="package-data">PackageData Object Attributes</h3>

`PackageData` is a set of key/value pairs that correspond to the metadata fields in a Universal Package. It's used as output data for the [List Packages](/docs/proget/upack/proget-api-universalfeed/proget-api-universalfeed-list)
 Endpoint as a JSON-formatted object.

| Property | Format| Notes|
|---|---|---|
| `group` | string | the group of the package|
| `name` | string | the name of the package |
| `latestVersion` | float | the latest version of the package |
| `title` | string | the title of the package |
| `description` | string | the description of the package |
| `downloads` | int | number of downloads performed |
| `isLocal` | bool | indicates if the package is hosted locally |
| `isCached` | bool | indicates if the package is cached |
| `versions` | array | an array of existing version numbers |

#### JSON Object

```json
[
  {
    "group": "MyGroup",
    "name": "MyUniversalPackage",
    "latestVersion": "2.0.4",
    "title": "Test Package",
    "description": "Test Package for API Documentation",
    "downloads": "5",
    "isLocal": true,
    "isCached": false,
    "versions": ["2.0.4", "1.2.3", "1.0.0"]
  },
  { ... } // other packages
]
```

<h3 id="version-data">VersionData Object Attributes</h3>

`VersionData` is a set of key/value pairs that correspond to the metadata fields in a Universal Package version. It's used as output data for the [List Versions](/docs/proget/upack/proget-api-universalfeed/proget-api-universalfeed-version)
 Endpoint as a JSON-formatted object.

| Property | Format| Notes|
|---|---|---|
| `isLocal` | bool | indicates if the package is hosted locally |
| `isCached` | bool | indicates if the package is cached |
| `isVirtual` | bool | indicates if the package is a virtual package |
| `sha1` | string | `hash` of package |
| `title` | string | the title of the package |
| `description` | string | the description of the package |
| `group` | string | the group of the package |
| `name` | string | the name of the package |
| `version` | float | the version of the package |
| `downloads` | int | number of downloads performed |
| `published` | datetime | timestamp when package was published to the feed |
| `size` | int | the size of the package in bytes |	
| `fileList` | array | an array of [FileData](#file-data) objects |	

#### JSON Object

```json
{
  "isLocal": true,
  "isCached": false,
  "isVirtual": false,
  "sha1": "00c1624a6bc2fbed3a8b49c9c90fa4f2b4a1241e",
  "title": "Test Package",
  "description": "Test Package for API Documentation",
  "group": "MyGroup",
  "name": "MyUniversalPackage",
  "version": "1.0.0",
  "downloads": 6,
  "published": "2023-12-11T02:13:47.86Z",
  "size": 1435884,
  "fileList": [ FileData objects ]
}
```

<h3 id="file-data">FileData Object Attributes</h3>

`FileData` is a subset of attributes on the [VersionData](#version-data) Object that corresponds to fields of a file within a universal package. It's used as output data for the [List Versions](/docs/proget/upack/proget-api-universalfeed/proget-api-universalfeed-version)
 Endpoint as a JSON-formatted object.

| Property | Format| Notes|
|---|---|---|
| `name` | string | the name of the package |
| `size` | int | the size of the package in bytes |	
| `date` | datetime | timestamp when file was added to package |	

#### JSON Object

```json
{
    "name": "example.bin",
    "size": 1543944,
    "date": "2023-12-08T10:25:50Z"
}
```