---
title: "Upgrading BuildMaster"
order: 2
url-slug: "buildmaster-upgrading"
---

BuildMaster is self-managed, which means you can decide when and how often to upgrade. When planning an upgrade for your BuildMaster instance, there are two categories of releases that you should consider:

* **Maintenance releases** are low risk and contain only backward-compatible enhancements, bug fixes, and security patches; we recommend upgrading to the latest maintenance release at least once every quarter
* **Major releases** typically implement a brand new feature or revise an existing feature and are inherently higher risk than a maintenance release; we recommend reading the release notes carefully before planning to upgrade

To learn more, see: [When should I upgrade my Inedo Product?](/docs/installation/upgrading#when-should-i-upgrade-my-inedo-product)

## BuildMaster Upgrade Path
You can find which version of BuildMaster you're currently using in the bottom-right corner of the BuildMaster web application.

| Current Version | Upgrade Path |
| --- | --- 
| BuildMaster&nbsp;2023.\* | *This is the current release, and you should perform regular maintenance upgrades to stay up to date.*
| BuildMaster&nbsp;2022.\*<br />BuildMaster&nbsp;7.0.\*<br />BuildMaster&nbsp;6.2.\* | Upgrade directly to latest BuildMaster 2023 ([see notes](/docs/buildmaster-upgrade-2023))
| BuildMaster 6.1.\*<br />BuildMaster&nbsp;6.0.\* | Upgrade to latest BuildMaster 6.1, then to latest BuildMaster 2022 ([see notes](/docs/buildmaster-upgrade-2022))
| BuildMaster 5.\*.\* | Upgrade to latest BuildMaster 6.1, then to latest BuildMaster 2022 ([see v5 notes](/docs/buildmaster/installation-maintenance/buildmaster-upgrading/upgrading-from-buildmaster-v5))
| BuildMaster 4.\*.\* <br />BuildMaster  3.\*.\* | Upgrade to  BuildMaster 4.9.10, then to latest BuildMaster 6.1, and then to latest BuildMaster 2022 ([see v3/v4 notes](/docs/buildmaster/installation-maintenance/buildmaster-upgrading/upgrading-from-buildmaster-v3-and-v4))
| BuildMaster&nbsp;2.\*.\* <br />BuildMaster&nbsp;1.\*.\* | Retire instance and start from scratch

## How to Upgrade BuildMaster

The method you use to upgrade BuildMaster depends on [how you installed BuildMaster](/docs/buildmaster/installation-maintenance/buildmaster-installation-guide). However, we recommend that you [make a backup copy](/docs/installation/backing-up-restoring) before upgrading in case something goes wrong and you need to roll back. This is especially important if you are performing a major upgrade.

### Windows Servers (Inedo Hub)
If you installed BuildMaster on Windows using the [Inedo Hub](/docs/installation/windows/desktophub-overview), it's an easy process.

![Inedo Hub](/resources/docs/Inedo%20Hub%20Home%202.png)

Simply click Upgrade next to BuildMaster, select the desired version, and click Install.

### Linux Servers (Docker)

If you installed BuildMaster on Linux, you can follow our [upgrading your Docker containers guide](/docs/installation/linux/installation-upgrading-docker-containers) to learn more.
