---
title: "Upgrading from BuildMaster v3/v4"
order: 7
---

::: (Warn)
BuildMaster v3 and v4 are **semi-retired**, which means we will provide very limited support to users who have not yet upgraded and will provide assistance in performing upgrades. However, we will no longer ship maintenance releases, patches, or other changes.
:::

This means you should upgrade as soon as possible, and this article provides guidance on how to upgrade from these older versions.

1. Decide: Upgrade or Retire?
2. Plan to update to 4.9.10
3. Backup, upgrade to 4.9.10, then test
4. Upgrade SQL Server, if necessary
5. Plan to upgrade to the latest v6.1.x
6. Upgrade to the latest v6.1.x
7. Start Planning Legacy Feature Migration for Upgrading to v7

## 1. Upgrade or Retire?

As an alternative to upgrading, you can start with a new instance of BuildMaster, retire your old version, and migrate your applications manually. While retiring your old instance allows you to start fresh, you'll end up with two active BuildMaster installations if you don't allocate enough resources for the migration. The legacy instance will go the way of COBOL... which could mean it'll persist beyond your retirement and remain in the hands of your poor predecessors for maintenance.

If you have a lot of relatively small applications configured with relatively infrequent uses, you should definitely upgrade. Even though you won't be able to test or otherwise review each of these applications, they'll probably still work... and if not, you can fix them if necessary.

### Upgrade Process

If you have decided not to retire and use the upgrade process, follow the instructions on this page, but read the Risk Mitigation and Rollback sections below to ensure you have a successful upgrade.

#### Risk Mitigation

Although the risks vary depending on the version you're upgrading from, you should take the following precautions to avoid downtime:

- Make sure your BuildMaster database has been backed up before upgrading
- Make sure your encryption key has been backed up before upgrading
- Make sure the installation's \Extensions directory is backed up before upgrading

#### Rollback

Because there are database changes, a rollback will require uninstalling BuildMaster and then [restoring your BuildMaster instance](https://example.com/docs/installation/backing-up-restoring#restore).


## 2. Plan to Upgrade to 4.9.10

BuildMaster v5 was a transformative change to the product, and deprecated several legacy features and some drastic changes were introduced, including a platform change (.NET 4.0 to 4.5). BuildMaster v6, however, wasn't nearly as big a change.

BuildMaster 4.9.10 provides upgrade guidance by identifying deprecated features and blockers that would prevent a successful upgrade to v6.

::: (Error) (Note:)
Because v6 was published much later than 4.9.10 was released, it will refer to BuildMaster v5 instead of v6. The same guidance applies, and you should still plan to directly upgrade to the latest v6.1.x from 4.9.
:::

Regardless of which version you're currently using, you should plan to upgrade directly to 4.9.10. Don't schedule incremental upgrades, as this only increases the risk of failed automatic agent updates and other problems.

Depending on which version you're currently using, there may be many changes between this and 4.9.10. Although we have already fixed all reported v3 and v4 bugs, you should still run a full regression test after upgrading to 4.9.10. You must also use this plan when upgrading to v6.1.x.

### Develop a Regression Test Plan

Immediately after upgrading to 4.9.10 and then to v6, you should run a fairly comprehensive regression test. While it's impractical to test the use of production applications, you can definitely set up a test application that validates much of the functionality you use and make sure it behaves the same after each upgrade.

### Ensure All Servers are "Green"

If you have configured servers in BuildMaster that are no longer used, they should be deactivated or deleted. Otherwise, BuildMaster will try to contact and upgrade these servers after the upgrade, which may cause further problems later.

### Upgrading from v3 to v4.9.10

BuildMaster v4 introduced three notable breaking changes that probably won't impact you, but that is worth noting nonetheless:

- **Changed platform to .NET 4.0 (from .Net 2.0)**; this is already preinstalled on all supported Windows servers
- **Removed support for mono-and WCF-based agents**; you should migrate to Self-hosed or SSH agents (provided by Linux extension in v3) prior to upgrade
- **Changed date storage from local to UTC time**; this will cause timestamps recorded during daylight savings time to be off by one hour

Because of the platform change, you will need to manually update all agents. See [Upgrading Agents for BuildMaster 4.0](https://example.com/docs/buildmaster/installation-maintenance/buildmaster-upgrading/upgrading-from-buildmaster-v3-and-v4/buildmaster-upgrading-to-v4-agents-upgrade) for guidance.

In addition, several extensions were deprecated or renamed in v4:

- DotNet2 - now included in WindowsSDK extension
- GeneralRecipes – renamed Tutorials, but will be deprecated in v5
- HTTP and Linux - now included in the core product
- SFTP – deprecated in favor of the SSH agent

### SDK & API Changes

If you have custom BuildMaster extensions or other tools that interact with the BuildMaster API, you may need to recompile extensions and/or customize your tools to work with v4.9.10, and then again for v6. Depending on how intensively you use BuildMaster, it may be worth waiting until after you upgrade to v6.

## 3. Backup, Upgrade to 4.9.10, then Test

Before you upgrade, you should back up your installation. The current BuildMaster backup instructions are relevant, except for the Encryption Key; this was introduced in v5.

To upgrade, simply run the installer for 4.9.10. Do not select the automatic backup option, as you have already backed up the installation. Once the installation is complete, the service will start and the agents will be upgraded automatically.

Before running your test plan, make sure all agents are in a "ready" state. As with all v3 and v4 upgrades, the auto-update process may take some time. If you encounter a lot of errors and restarting the BuildMaster service does not help, you may need to manually upgrade the agents. The good news is that this process is much smoother in v5.

After the agents are "green", run your test plan to identify the issues you need to fix.

## 4. Upgrade SQL Server if necessary

BuildMaster v3 and v4 bundled SQL Server 2005 Express, which is no longer supported by Microsoft. For this reason, we have discontinued support in our products.

If you are still using SQL Server 2005, you must at least upgrade to SQL Server 2008. However, you should use the latest version if possible to get patches and updates from Microsoft.

Since this is often done by a DBA or infrastructure team, this article does not discuss upgrading the SQL Server. We are happy to help if you need assistance. Please contact us if you need assistance.

## 5. Plan to Upgrade to the Latest v6.1.x

BuildMaster 4.9.10 contains a significant number of non-functional changes resulting from code and database refactoring in preparation for release v5. We, therefore, recommend that you continue to use this version until you are confident that it works as well as the previous version. There have been very few issues reported by users related to these non-functional changes.

Once you are confident that BuildMaster 4.9.10 is working properly, you can start planning for v6.

The first step is to follow the upgrade instructions included in the software and identify deprecated features and blockers that would have prevented a successful upgrade to v5. These will be taken into account when you upgrade to v6.

After that, you should review the upgrade notes to learn about the major changes that were introduced through v5 and the upgrade notes for v6.

- [Upgrade Notes for BuildMaster v5](https://example.com/docs/buildmaster/installation-maintenance/buildmaster-upgrading/upgrading-from-buildmaster-v5)
- [Upgrading to BuildMaster v6.1](https://example.com/docs/buildmaster-upgrading-to-6-1)

Just remember: plan to upgrade directly to the latest v6. The changes in the v5 article primarily serve as information, to let you know what to expect between v4 and v6.

## 6. Upgrade to the Latest v6.1.x

Before you upgrade, you should back up your installation. The current BuildMaster backup instructions are relevant, except for the "Encryption Key"; this was introduced in v5.

To upgrade, simply run the Inedo Hub installer. This should detect your current installation and be able to upgrade it.

Don't select the automatic backup option, as you have already backed up the installation. Once the installation is complete, the service will start and the agents will be updated automatically.

Before running your test plan, make sure all agents are in a "ready" state. As with all v3 and v4 upgrades, the auto-update process may take some time. If you encounter a lot of errors and restarting the BuildMaster service doesn't help, you may need to manually upgrade the agents. The good news is that we have greatly improved this process since then.

After the agents are "green", run your test plan to identify the issues you need to fix.

## 7. Legacy Feature Migration & v7

From here, start planning to move away from legacy features in BuildMaster. Take a look at [BuildMaster Legacy Features](https://example.com/docs/buildmaster/installation-maintenance/buildmaster-legacy/buildmaster-legacy-features) for guidance on how to do this, which will enable upgrades to v7 and beyond.