---
title: "PowerShell"
order: 4
---

A PowerShell feed is a specialized type of [NuGet](/docs/proget/feeds/nuget) feed intended to store PowerShell modules. It is accessible directly from [PowerShellGet](https://docs.microsoft.com/en-us/powershell/module/powershellget).

## Installing Modules 

PowerShell packages are installed using [PowerShell](https://docs.microsoft.com/en-us/powershell/module/PowerShellGet/Install-Module). To install a package from a ProGet feed, use the following commands:

### 1. Register Repository

```powershell
PS> Register-PSRepository -Name "{feed-name}" -SourceLocation "http://{proget-server}/nuget/{feed-name}/"
```

### 2. Install Module

```powershell
PS> Install-Module -Name "{package-name}" -RequiredVersion "{package-version}" -Repository "{feed-name}"
```

## Differences from NuGet Feeds 

Since PowerShell module packages are actually NuGet packages, PowerShell feeds are functionally identical to NuGet feeds except for some user interface tweaks:

- PowerShell feed packages have their own icon to indicate that they are PowerShell modules
- Instructions for PsGet are displayed instead of NuGet in the installation instructions for a package
- Tags are not displayed on the Browse Feed page because PowerShell packages use them differently and typically have a large number of tags that make them impractical to display in an overview

## PowerShell Module Package Version Quirks 

Due to a validation error in the Microsoft-powered PowerShell gallery, several packages have two different version numbers: one in the .nuspec file and one in the module's .psd1 file.

This causes a number of problems, the most common of which is that a package ends up in the "wrong" location when installed from a ProGet repository on a Windows machine. For example, SqlServerDsc will install to `C:\Program Files\WindowsPowerShell\Modules\SqlServerDsc\12.2.0` while the .psd1 actually says 12.2.0.0. As a result, PowerShell refuses to load the module because it believes the manifest is incorrect.

A workaround is to disable caching for the PSGallery connector and then remove the incorrectly versioned packages (pull them into ProGet and then delete them). After that, ProGet can now deliver packages directly from the connector with the correct version number.

As of April 8th, 2019, this is being tracked in [PowerShellGallery Issue #55](https://github.com/PowerShell/PowerShellGallery/issues/55) and [workarounds are discussed on our forums](https://forums.inedo.com/topic/2643/proget-keeps-mangling-nuget-package-version-numbers).

### PowerShell Missing Packages 

Due to another bug in the Microsoft-powered PowerShell Gallery, its API reports that some packages are not present. The PowerShell client tries to work around this error by attempting to retry the query with a different query, but it only attempts this workaround when querying the PowerShell Gallery. It does not attempt this workaround when querying ProGet.

The simplest workaround for this error is to simply pull these packages locally.

As of October 1st, 2018, this is being tracked in [PowerShellGallery Issue #30](https://github.com/PowerShell/PowerShellGallery/issues/30).

## Publishing to a PowerShell Feed 

You can register and publish to a PowerShell feed in ProGet easily using PowerShell 5.0 or newer and [PowerShellGet](https://docs.microsoft.com/en-us/powershell/module/powershellget).

`Import-Module PowerShellGet`

```powershell
Register-PSRepository -Name MyProGetFeed -SourceLocation <ProGetUrl> /nuget/<FeedName>/ -PublishLocation <ProGetUrl>/nuget/<FeedName>/
Publish-Module -Path <ModuleFile> -NuGetApiKey <UserName>:<Password>-Repository MyProGetFeed
```
If you would prefer to use an API key instead of user name/password credentials, you can create a [Feed API Key](/docs/proget/api/apikeys) in ProGet and use the following format for `Publish-Module` instead:

```powershell
Publish-Module -Path <ModuleFile> -NuGetApiKey <API Key> -Repository MyProGetFeed
```

You can also read more on [improving your team's PowerShell module usage](https://blog.inedo.com/powershell/level-up/) on the Inedo blog.
