---
title: "Promote Build"
order: 5
---

*Promote Build* is available as both a `pgutil` command and an HTTP Request, and will promote a build of a project to a specified stage.

:::(Info) (🚀 Quick Example: Promoting a build with pgutil)
This example promotes build `1.2.3` of the project `myProject` to the production stage.

```bash
pgutil builds promote --project=myProject --build=1.2.3 --stage=Production
```
:::

## Command Specification (CLI)
The `builds promote` command is used to promote a build of a project.

The `--project`, `--build`, and `--stage` options are always required.

:::(info)(📄 Note: pgutil Sources)
Source options must also be specified unless you have the "Default" source configured. See [Working with Sources](/docs/proget/api/pgutil#sources) to learn more.
:::

**Promoting a build of a project** requires the project name (e.g. `myProject`), build number (e.g. `1.2.3`), and stage to promote to (e.g. `Production`)

```bash
pgutil builds promote --project=myProject --build=1.2.3 --stage=Production
```

## HTTP Request Specification
To promote a build of a project, simply `POST` to the URL with the `project name`, `build version`, `specified stage`, and an [appropriate API Key](/docs/proget/api/sca#authentication).

```plaintext
POST /api/sca/promote-build?project=«project»&version=«version»&stage=«stage»
```

## HTTP Response Specification

A successful `200` response body will promote the target build to the specified stage. A `403` response indicates a [missing, unknown, or unauthorized API Key](/docs/proget/api/sca#authentication).
