---
title: "Pre-Release Packages & Repackaging"
order: 2
---

ProGet's repackacing feature simplifies your package-based CI/CD pipelines by creating stable, production-ready packages from tested and verified pre-release versions. These "repackaged" packages have identical content, and ProGet maintains an audit trail within the package to track the original versions, who performed the operation, and when.

## How/When Should I Repackage?
This is a relatively complex topic. A good starting point is our guide on [How to Create CI/CD pipelines for your NuGet packages](https://blog.inedo.com/nuget/how-to-use-cicd-pipelines-for-packages).

Essentially, repackaging is performed as a package "advances" from one CI/CD pipeline stage to another. Repackaging leverages [Semantic Versioning's Prerelease Labels](https://semver.org/#spec-item-9) to effectively "change" a package version from unstable (e.g. `1.0.0-ci.8`) to less-unstable (e.g. `1.0.0-rc.8`), and eventually to a stable version (e.g. `1.0.0`).

![CI/CD Pipeline for NuGet packages](https://blog.inedo.com/wp-content/uploads/2023/01/NuGet_CICD.png)

This package-based CI/CD pipeline allows you to test exactly the same content at each stage without rebuilding packages that may have different content. It also ensures that pre-release versions of packages are never released and developers aren't confused by hundreds of different package versions.

While this CI/CD pipeline inevitably creates many pre-release versions of packages, you can use ProGet's [Retention Rules](/docs/proget/administration/retention-rules) to clean them up automatically.

## How to Repackage a Package

Repackaging is available for Universal and NuGet packages, and is generally done as part of a CI/CD process using the [Repackaging API](/docs/proget/api/packages/repackage). You can also perform repackaging using the ProGet web interface.

:::(Warning)
Repackaging is limited in ProGet Free. You can repackage, but only through the web interface (not through the API). Also, you cannot see who repackaged a package and when. On the History tab of the Package Summary page, the repackaging and promotion history is displayed as `date hidden` and `username hidden` in the log.
:::

 ### Repackaging in the Web UI
 
:::(Internal) (Private notes)
This should be rewritten as a proper step-by-step and have screenshots
:::

1. Access the "Package Summary" page for each Universal or NuGet package in ProGet.
2. Select "Repackage" from the drop-down menu.
3. Enter a new version number. Optionally, you can also specify a reason (for auditing purposes). 
 * If you select the same feed from the dropdown, the package will only be repackaged and remain in the same feed. 
 * If you select a *different* feed from the dropdown, the repackaged package will be moved to the destination feed (the repackaged version will *not* appear in the source feed).
4. Click Repackage


## Viewing and Auditing Repackage History 

ProGet allows users to view the repackaging audit trail on the package's History tab. The history shows key values about each repackaging event such as date, time, version, username, notes and more.

:::(Internal) (Private notes)
This  needs screenshots
:::

These historical audit trails are embedded in the package itself, allowing you to easily replicate or transfer that package to other feeds while preserving the repackaging history. For universal packages, the history is embedded in `upack.json`. For NuGet packages, the history is embedded (in the same JSON format) in `.progetRepackagingHistory.json` in the `.nupkg` file.

## Other Repackaging Options 

ProGet's Web UI and [Repackacing API](/docs/proget/packages/repackaging) make repackaging easy, but they're not the only options.

###  Repackaging & Promoting

You can also repackage and promote in one step by selecting a different target feed from the dropdown menu (at UI) or using the API.

:::(Internal) (Private notes)
Would be nice to show an example here.
:::


### Repackacing by Hand
A package is actually just a .zip file, which means you can manually repackage with a few simple steps:

1. download the package file
2. open the package file as a zip file 
3. edit the package manifest file and change the version number 
4. publish the edited package file

When ProGet performs these steps, it also adds an audit trail that appears on the Package History tab in the web interface.
* [Universal Package Manifests](/docs/proget/feeds/universal/universal-packages#manifest) use the built-in `repackageHistory` property
* NuGet packages have a `.progetRepackageHistory.json` file added to the root that's uses the same format as `repackageHistory`

### Using the upack CLI 

The `repack` command in the [Universal Package CLI (upack)](/docs/proget/feeds/universal/universal-packages#tools) can be used to repackage a package file, and offers the most flexibility.

####  Basic Repackaging (Changing Version Number)
```
PS C:\tmp\accounts> upack repack Accounts-1.0.0-ci.8.upack --version=1.0.0
```

#### Advanced  Repackaging (Custom Manifest)
You may wish to change custom metadata as you repackage. For example, if you wanted to rewrite the `description` of a package and add a `_serviceNowTicketId` that tracks back to an internal ticketing system, you could do so as follows:

First, create a file called `updated.json` contents:
```
{
  "description": "This is a new description and will overwrite the package's existing description",
  "_serviceNowTicketId": "1000"
}
```

Then, run the `repack` command:

```
PS C:\tmp\accounts> upack repack Accounts-1.0.0.upack --manifest=updated.json --overwrite
```

## Repackaging In Action
We use our [public BuildMaster instance](https://buildmaster.inedo.com) for our CI/CD pipelines, and our [public ProGet instance](https://proget.inedo.com) to host our .NET libraries (NuGet packages) and products (Universal Packages). 

You can find many examples on our public instances, but the `Inedo.ServiceMessaging` is a good start. It's a library that's used by all of our products.

The [Inedo.ServiceMessaging versions page](https://proget.inedo.com/feeds/NuGetLibraries/Inedo.ServiceMessaging/versions) will show you the most recent versions of this package and will include pre-releases. If you navigate to a specific version, such as [Inedo.ServiceMessaging-1.1.1](https://proget.inedo.com/feeds/NuGetLibraries/Inedo.ServiceMessaging/1.1.1)), you can see:
 * Repackacing from `-ci.3` and `-rc3` on the History tab
 * `.progetRepackageHistory.json` on the Files tab

The corresponding [Inedo.ServiceMessaging build](https://buildmaster.inedo.com/applications/66/builds/build?buildId=6951) in BuildMaster will show:
 * CI/CD pipeline from Build to Release
 * Scripts used to repackage
