---
title: "SCA (Builds & Projects)"
order: 8
---

The Software Composition Analysis (SCA) API provides several `pgutil` commands (available as `pgutil builds`) and HTTP endpoints for querying, creating, and updating [builds](/docs/proget/sca/builds), [projects](/docs/proget/sca/builds), and related data:

All http requests are made through the following base URL:

:::(info)
 `/api/sca/...`
:::

## pgutil Commands

All HTTP endpoints of the SCA API are available as `pgutil` commands. 

To find the list of commands available in `pgutil`, simply run `pgutil builds --help`. See [Getting started with pgutil](/docs/proget/api/pgutil) to learn more.

## Available HTTP Endpoints

The SCA API is comprised of endpoints for Builds, Projects, Issues, Comments and SBOM Documents:

### 🏗 Builds { #builds-endpoints }

[Create/Update Build](/docs/proget/api/sca/builds/create) - Creates or updates a build
[Get Build](/docs/proget/api/sca/builds/get) - Describes a specified build
[List Build](/docs/proget/api/sca/builds/list) - Lists and describes specified build
[Analyze Build](/docs/proget/api/sca/builds/analyze) - Runs an analysis on a specified build
[Promote Build](/docs/proget/api/sca/builds/promote) - Promotes a build to a specified stage
[Scan Build](/docs/proget/api/sca/builds/scan) - Generates a minimal SBOM from project dependencies*

*\* Only available as a pgutil command.*

### 🛠️ Projects { #projects-endpoints }

[Create/Update Project](/docs/proget/api/sca/projects/create) - Creates or updates a project
[Get Project](/docs/proget/api/sca/projects/get) - Describes a specified project*
[List Projects](/docs/proget/api/sca/projects/list) - Lists and describes specified projects

*\* Only available as an HTTP request.*

### 🚩 Issues { #issues-endpoints }

[List Issues](/docs/proget/api/sca/issues/list) - Lists and describes specified issues
[Delete Issues](/docs/proget/api/sca/issues/delete) - Deletes a specified issue
[Resolve Issue](/docs/proget/api/sca/issues/resolve) - Sets a specified issue to resolved

### 💬 Comments { #comments-endpoints }

[Create/Update Comment](/docs/proget/api/sca/comments/create) - Creates or updates a comment
[List Comments](/docs/proget/api/sca/comments/list) - Lists and describes specified comments
[Delete Comment](/docs/proget/api/sca/comments/delete) - Deletes a specified comment

### 📄 SBOM Document { #SBOM-endpoints }

For managing ["Software Bill of Material"](/docs/proget/sca/builds/proget-sca-sbom-importing-exporting#what-is-a-software-bill-of-materials-sbom) (SBOM) documents

[Export SBOM](/docs/proget/api/sca/sbom/export) - Exports a SBOM document from ProGet
[Import SBOM](/docs/proget/api/sca/sbom/import) - Imports a SBOM document to ProGet*

*\* Only available as an HTTP request.*

## Authenticating to SCA Repository API { #authentication }

The following is a summary of access types and their corresponding requirements for various API key types and endpoints within this API.

| Access Type | Requirements |
| --- | --- |
| System API Keys | `Upload SBOM documents` only required to import SBOMs <br /> `Manage SCA (Projects & Builds)` required for all other endpoints |
| Feed API Keys | *not usable* |
| Personal API Key* | `Projects_Manage` can access all endpoints <br /> `Projects_View` is required for [Get Build](/docs/proget/api/sca/builds/get), [List Build](/docs/proget/api/sca/builds/list), [Get Project](/docs/proget/api/sca/projects/get), and [List Project](/docs/proget/api/sca/projects/list) <br /> `Projects_UploadSbom` is required for [Import SBOM](/docs/proget/api/sca/sbom/import) <br /> `Projects_ResolveIssue` is required for [Resolve Issue](/docs/proget/api/sca/issues/resolve) | 
| No API Key | anonymous or authenticated user must have at  one of the above permissions |

*\* Personal API keys are scoped to users and inherit the [Tasks and attributes](/docs/proget/administration-security#tasks) assigned to those users.*

To specify an API Key, use the request header (`X-ApiKey`), querystring (`key`), or `api:«api-key»` as the username. See [API Key Usage](/docs/proget/api/apikeys#using-api-keys) to learn more.

:::(Info) (🚀 Quick Example: Authenticating with curl)
For example, to authenticate with the API key `abc12345` to [List Projects](/docs/proget/api/sca/projects/list), you could specify the API key as follows:

```plaintext
curl -X GET -H "X-ApiKey: abc12345" "https://proget.corp.local/api/sca/projects"
```
:::