---
title: "Import SBOM"
order: 2
---

*Import SBOM* is available as an HTTP Request, and will import an existing [SBOM](/docs/proget/sca/builds/proget-sca-sbom-importing-exporting#what-is-a-software-bill-of-materials-sbom) document into ProGet and create corresponding project and release information from it.

:::(Info) (🚀 Quick Example: Importing an SBOM with curl)
This example imports a locally stored SBOM of version `1.2.3` of a project `myProject` as an `XML`, authenticating with the API key `abc12345`:

```bash
curl -X POST -H "X-ApiKey: abc12345" -H "Content-Type: text/xml" -d "@C:/Users/Inedo/myProject-1.2.3.xml" https://proget.corp.local/api/sca/import
```
:::

## HTTP Request Specification
To import an SBOM document, simply `POST` to the URL with an [appropriate API Key](/docs/proget/api/sca#authentication).

```plaintext
POST /api/sca/import
```

Note that the `Content-Type` header should either be `text/xml` (XML) or `application/json` (JSON) depending on the import format.

**Importing an SBOM** requires the `project` name (e.g. `myProject`), the `version` (e.g. `1.2.3`), and either an `XML` or `JSON` as the body (e.g. `sbom.xml`):

```plaintext
POST /api/sca/import

«contents of sbom.xml»
```

## HTTP Response Specification

A successful `200` response will indicate the SBOM was successfully imported. A `403` response indicates a [missing, unknown, or unauthorized API Key](/docs/proget/api/sca#authentication).
