---
title: "アセットとファイルの保管"
order: 4
hidden: true
---

ProGet は、パッケージ管理システムです。ProGet は、アプリとコンポーネントパッケージのホスティングおよび配布のためのインフラストラクチャとして利用できます。

パッケージを配布する際、バージョン管理や、マニフェストが不要な、ファイルを一緒に配布することがあるでしょう。例えば、証明書ファイル、サードパーティのインストーラ、ライセンスキーファイルなど、配布したいパッケージに関連・付随するファイルです。

これらのファイルをパッケージ化することもできますが、パッケージ化が不要なファイルもあります。

アセットディレクトリとは、パッケージ管理に付随する、パッケージ化が不要なファイルを保管・管理・配布するための機能です。

例：コンフィギュレーションスクリプトが、ワークステーションの設定をするためにインストーラを使うことがあります。インストーラは自己完結型のパッケージなので、これ以上パッケージ化する必要はありません。必要なのはダウンロードと実行のみです。そのままアセットディレクトリ内に保存すれば、URL で参照もできます。

## **アセットディレクトリ**

アセットディレクトリも、パッケージフィードやリポジトリのように扱えます。フィードの中にあるファイルには、ブラウザや RESTful API などからアクセスできます。

ProGet 上で、アセットディレクトリはフィードとして表示されます。そのため、

- フィードごとのアクセス権は、アセットディレクトリにも適用できる
- AmazonS3 と AzureBlob ストレージの構成ができる
- [リテンションポリシー](/docs/inedo-日本語ヘルフ/proget-jp/管理機能/jp-proget-retention-rules){target="_blank"}は通常のフィードと同様に動作するが、バージョン番号ベースのポリシーは適用されない
- アセットディレクトリは別のフィード名と重複する名前を使用できない

注釈：現時点で、[コネクタ](/docs/inedo-日本語ヘルフ/proget-jp/フィートリホシトリの作成と管理/jp-proget-connector-overview){target="_blank"} や [フィードレプリケーション](/docs/inedo-日本語ヘルフ/proget-jp/高度な機能/jp-proget-feed-replication){target="_blank"}、および[クラウドパッケージストレージ](/docs/inedo-日本語ヘルフ/proget-jp/高度な機能/jp-proget-cloud-storage){target="_blank"}はアセットディレクトリに対応していません。ですが、将来のリリースで追加される可能性もあります。興味のある方はご連絡ください。

アセットディレクトリの作成は、[Assets (アセット)] > [Create Asset Directory (アセットディレクトリを作る)] から行ってください。

### **アセットディレクトリ内のファイル**

アセットディレクトリにファイルを追加する方法は複数あります。

- ファイルのアップロード： ブラウザを使用し単一のファイルをアップロードする。
- アーカイブのインポート： ブラウザから .zip または .tgz ファイルをアップロードし、内容をアセットディレクトリに展開する。
- APIを使用してアップロード： アセットディレクトリ APIを使用して、1つまたは複数のファイルをアセットディレクトリにアップロードする。
- 大容量ファイルまたは複数ファイルのアップロード：大容量ファイル（1GB以上）または複数のファイルを一度にアップロードする。ディレクトリパッケージストレージメカニズムを使用しているアセットディレクトリにのみ対応している方法です。

ファイルのURLに移動することで、Webサーバー上でホストされているように、アセットディレクトリ内のファイルにアクセスもできます。（[アセットディレクトリ API](/docs/proget/api/assets)（リンク先英語）を参照）このURLは、Web UIのファイル情報ページにも表示されます。

**ファイルの削除**

アセットディレクトリ内のファイルを削除するには、ファイル一覧ページの「X」 かファイル概要ページの「Delete File」ボタンをクリック、または[アセットディレクトリAPI](/docs/proget/api/assets)（リンク先英語）から削除してください。

**メディアタイプ**

アセットディレクトリにファイルをアップロードした場合、ProGetはファイルに[メディアタイプ](https://en.wikipedia.org/wiki/Media_type)（リンク先英語）を割り当てます。メディアタイプは、ファイルがダウンロードされた時にコンテンツタイプ・レスポンスヘッダーとして送信され、ダウンロードをするアプリもしくはスクリプトによって使用される可能性があります。

例えばコンテンツタイプが application/msword なら、ウェブブラウザが Microsoft Word を開いてファイルを表示します。Web UI 内で、メディアタイプを変更したいファイルに移動し、[set (セット)] オプションをクリックすると、そのファイルの メディアタイプを変更できます。

**サブディレクトリ**

ファイルシステムと同様、サブディレクトリを使用しアセットディレクトリ内のファイルを整理できます。サブディレクトリには、他のサブディレクトリも含まれている可能性があります。

サブディレクトリの削除は、ファイル一覧ページの「X」をクリックするか、アセットディレクトリAPIから行います。