---
title: "BuildMaster Application Management API"
order: 8
---

The Application Management API has [Endpoints](#endpoint-specifications) to help list, create, update, and purge applications, and are intended to automate the setup and management of applications in your BuildMaster instance:

* [Create Application Endpoint](/docs/buildmaster/reference/api/buildmaster-appmanagement-api/buildmaster-appmanagement-create) - Create a blank application

* [Clone Application Endpoint](/docs/buildmaster/reference/api/buildmaster-appmanagement-api/buildmaster-appmanagement-clone) - Clones an existing application

* [Import Application Endpoint](/docs/buildmaster/reference/api/buildmaster-appmanagement-api/buildmaster-appmanagement-import) - Create an application from an exported package

* [Update Application Endpoint](/docs/buildmaster/reference/api/buildmaster-appmanagement-api/buildmaster-appmanagement-update) - Update an existing application

* [Purge Application Endpoint](/docs/buildmaster/reference/api/buildmaster-appmanagement-api/buildmaster-appmanagement-purge) - Purge an existing application

* [List Application Endpoint](/docs/buildmaster/reference/api/buildmaster-appmanagement-api/buildmaster-appmanagement-list) - Lists all existing applications

::: (info)
This API is only intended to update application settings; see the [Variables Management API](/docs/buildmaster/reference/api/variables) and [Release & Build Deployment API](/docs/buildmaster/reference/api/release-and-build) to manage other application configuration.
:::

<h2 id="authentication">Authentication</h2>

An API Key with the Application Management permission is required to use this API.

It can be passed to each endpoint in one of four ways, depending on the content type of the expected request:

| Method | Name or Key | Details |
|----|----|----|
|Request header| `X-ApiKey` | *all content types* |
|Querystring value| `key` | *all content types* |
|Form value| `key` | only `applications/x-www-form-urlencoded` content type |
|JSON property | `API_Key` | on root object, only `application/json` content type |

To specify an API Key, use the request header (`X-ApiKey`), querystring (`key`), or `api:«api-key»` as the user name. See [API Access and API Key](/docs/buildmaster/reference/api/buildmaster-administration-security-api-keys) to learn more.

::: (info) (🚀 Quick Example: Authenticating with curl)
For example, to authenticate with the API key `a1b2c3d4e5` to the create application endpoint, you could specify the API key as follows:
````
curl -X POST --header "X-ApiKey: a1b2c3d4e5" "https://buildmaster.corp.local/api/applications/create"
````
If the provided API key is either missing, unknown/incorrect or does not have permission, the following message is returned:
````
The specified API key does not have the proper permissions to perform this action.
````
:::

<h2 id="data-specifications">Data Specifications</h2>

<h3 id="application-info">ApplicationInfo Object</h3>

`ApplicationInfo` is a set of key/value pairs that correspond to the fields on the Application > Basic Settings and Advanced Settings pages. It's used as both input and output data for various endpoints:

* **Output:** The [Create](/docs/buildmaster/reference/api/buildmaster-appmanagement-api/buildmaster-appmanagement-create), [Update](/docs/buildmaster/reference/api/buildmaster-appmanagement-api/buildmaster-appmanagement-update), and [List](/docs/buildmaster/reference/api/buildmaster-appmanagement-api/buildmaster-appmanagement-list) Application Endpoints return `ApplicationInfo` as a JSON-formatted object; all values are returned

* **Input:** The [Create](/docs/buildmaster/reference/api/buildmaster-appmanagement-api/buildmaster-appmanagement-create), and [Update](/docs/buildmaster/reference/api/buildmaster-appmanagement-api/buildmaster-appmanagement-update) Application Endpoints receive `ApplicationInfo` as either a JSON-formatted object, querystring parameter, or form-encoded data; a missing property indicates that the value should not be updated

Note that some values are optional (indicated by `string?`), and may be set to `null` or an empty string.

| Property | Format | Notes
| --- | --- | ---
| `id` | int | Internal ID of application
| `name` | string  | Must be unique across the system
| `description` | string? |
| `groupName` | string? | `null` to be ungrouped
| `active` | bool | `false` indicates a deactivated application
| `setupTemplate` | string? | Name of the Setup template to use or `null` to not use one
| `buildNumberScheme` | string  | Sequential, DateTimeBased, or Unique
| `releaseUsage` | string  | Required, Optional, or Disabled
| `defaultReleaseTemplate` | string? | Name of the or `null` to use the Default template
| `allowIssues` | bool |
| `displayIssues` | bool |
| `displayPipelines` | bool |
| `displayScripts` | bool |
| `displayConfiguration` | bool |
| `displayDatabase` | bool |
| `buildPageDescription` | string? |
| `artifactUsage` | string  | Default, None, FileSystem, or AssetDirectory
| `artifactAssetDirectory` | string? | When `artifactUsage` is AssetDirectory, this field must be the name of an Asset Directory secure resource; otherwise `null`
| `raft` | string? | Name of a raft or `null` to use the Default raft

#### JSON Object:

```
{
  "id": 123,
  "name": "myApplication",
  "description": "This is a sample application.",
  "groupName": myGroup,
  "active": true,
  "setupTemplate": "BasicSetup",
  "buildNumberScheme": "Sequential",
  "releaseUsage": "Required",
  "defaultReleaseTemplate": null,
  "allowIssues": true,
  "displayIssues": true,
  "displayPipelines": true,
  "displayScripts": true,
  "displayConfiguration": true,
  "displayDatabase": true,
  "buildPageDescription": "This page provides information about the build.",
  "artifactUsage": "FileSystem",
  "artifactAssetDirectory": null,
  "raft": "MainRaft"
}
```
<h3 id="clone-application">CloneApplication Object</h3>

`CloneApplication` is a set of key/value pairs that provide direction on creating a new application. It's used as input for the [Clone Application Endpoint](/docs/buildmaster/reference/api/buildmaster-appmanagement-api/buildmaster-appmanagement-clone).

This will behave the same as cloning that application from the UI.

| Property | Format | Notes
| --- | --- | ---
| `name`| string | The name of the new application to create
| `from` | string | The name or id of an application to clone
| `raft` | string? | Name of a raft or `null` to use the Default raft

#### JSON Object
```
{
  "name": "NewApplication",
  "from": "ExistingApplication",
  "raft": "CustomRaft"
}
```

<h3 id="import-application">ImportApplication Object</h3>

`ImportApplication` is a set of key/value pairs that provide direction on creating a new application. It's used as input for the [Import Application Endpoint](/docs/buildmaster/reference/api/buildmaster-appmanagement-api/buildmaster-appmanagement-import).

Depending on the value of the properties, this behaves like creating an application from a template, reapplying a template, creating a sample application, or restoring an application from a backup.

| Property | Format | Notes
| --- | --- | ---
| `name` | string | The name of the new application to create
| `packageSource` | string | The name of a Universal Feed secure resource
| `packageId` | string | The id of the package to import (not the name)
| `packageVersion` | string | The version of the package to import or latest for the latest version
| `importHistory` | bool | When set to `true`, historical data in the package like Build and Executes will be imported
| `overwrite` | bool | When set to `false`, if an application with the specified name already exists, an error will occur; otherwise, any items in the Package will overwrite the configuration
| `raft` | string? | Name of a raft or `null` to use the "Default" raft

#### JSON Object:
```
{
  "name": "NewApplication",
  "packageSource": "MyUniversalFeed",
  "packageId": "com.example.myapp",
  "packageVersion": "1.0.0",
  "importHistory": true,
  "overwrite": false,
  "raft": null
}
```