---
title: "CRAN (R)"
order: 17
---

The Comprehensive R Archive Network ([CRAN](https://cran.r-project.org/)) is the main repository for packages written for the R language. Since version 2023.23, ProGet supports CRAN feeds to host R packages.

## Installing Packages

R packages are installed using the `install.packages` method. To install a package from a ProGet feed, use the following command:

```r
install.packages("«package-name»", repos="http://«proget-server»/cran/«feed-name»/")
```

### Installing Specific Versions

The `install.packages` method can only install the latest version of a package. If you need to install a previous version, the easiest way is to download the package first and install from the file.

You can also use the [`install_version` function](https://remotes.r-lib.org/reference/install_version.html) from the [remotes](https://remotes.r-lib.org/) library.

## Authenticating to Cran Feeds

If you've configured your feed to require authentication, you must pass a username and password in using the url:

```r
install.packages("«package-name»", repos="https://«username»:«password»@«proget-server»/cran/«feed-name»/")
```

You can also create an [API Key](/docs/proget/api/apikeys), entering `api` as the username and the API key as the password.

When creating an API Key, fill in the fields by selecting "Feeds ("Use Certain Feeds)" as the "Feed Type" and selecting the CRAN feed to authenticate to. Make sure that the required permission boxes are checked, and then select "Create API Key".

![](/resources/docs/proget-cran-apikey-2.png){height="" width="50%"}

Next, add the feed to your local R environment. For this you will need to enter your API key, in addition to the URL.

For example, authenticating to http://proget.corp.local/cran/public-cran/ using the API key `abc12345` you would enter:

```r
install.packages("devtools", repos="http://api:abc12345@proget.corp.local/cran/public-cran/")
```

or add it as your RPM feed as a custom repository by entering:

```r
options(repos = c(ProGet = "http://api:abc12345@proget.corp.local/cran/public-cran/"))
```

Confirm that it was set by entering:

```r
getOption("repos")
```

You can also configure this in RStudio by navigating to "Tools" > "Global Options" > "Packages" and selecting "Change" and then entering the feed URL in the "Custom" field.

![](/resources/docs/rstudio-customrepo-internal-apikey.png){height="" width="50%"}

## Creating and Publishing Packages

To learn how to create and publish an R package that can be hosted by ProGet, can read our [HOWTO: Create and Upload CRAN Packages to a Private Repository in ProGet](/docs/proget/feeds/cran/howto-cran-publish) guide.

## Connecting to External Repositories

You can create a connector to any CRAN-like repository such as `https://cran.r-project.org/`. This will allow you to proxy the external feed through ProGet, including any binary packages, but browsing through the web application is limited, since CRAN repositories typically only expose the latest version of each package with very little accompanying metadata.

## Technical Limitations

### Binary Packages

ProGet can store binary packages, but currently, the only way to add them to your feed is by caching them through a connector. Binary packages are typically built by CRAN rather than by package authors directly, so ProGet doesn't support directly uploading them. Let us know if you'd like this capability and we will consider adding it to a future version.
