---
title: "Connectors"
order: 6
---

The Connectors API provides several `pgutil` commands (available as `pgutil connectors`) and HTTP endpoints to query, create, and update [connectors](/docs/proget/feeds/connector-overview), and related data:

## pgutil Commands

All HTTP endpoints of the Connectors API are available as `pgutil` commands. 

To find the list of commands available in `pgutil`, simply run `pgutil connectors --help`. See [Getting started with pgutil](/docs/proget/api/pgutil) to learn more.

## Available HTTP Endpoints

* [Create Connector](/docs/proget/api/connectors/create) - creates a specified connector
* [Get Connector](/docs/proget/api/connectors/get) - describes an specified connector
* [List Connectors](/docs/proget/api/connectors/list) - describes all connectors, filtered as specified
* [Update Connector](/docs/proget/api/connectors/update) - updates a specified connector
* [Delete Connector](/docs/proget/api/connectors/delete) - deletes a specified connector

## Authenticating to Connectors Management API { #authentication }

The following is a summary of access types and their corresponding requirements for various API keys types and endpoints within this API.

| Access Type | Requirements |
| --- | --- |
| System API Keys | `Use/Manage Feeds` is required for all endpoints  | 
| Personal API Key | `Admin_ConfigureProGet` is required for all endpoints |

*\* Note: A Feed API Key cannot be used with the Connector API.*

To specify an API Key, use the request header (`X-ApiKey`), querystring (`key`), or `api:«api-key»` as the username. See [API Key Usage](/docs/proget/api/apikeys#using-api-keys) to learn more.

:::(Info) (🚀 Quick Example: Authenticating with curl)
For example, to authenticate with the API key `abc12345` to the list connectors endpoint, you could specify the API key as follows:

```bash
curl -X GET --header "X-ApiKey: abc12345" "https://proget.corp.local/api/management/connectors/list"
```
:::

## Notes about Data

### Wildcards and Negations
Certain fields noted above support wildcard and negation syntax. For example, the value `["Microsoft.*", "Castle.*", "!Rubbishsoft.*"]` has the following properties:
 - includes any packages that start with `Microsoft.` or `Castle.*`
 - excludes any packages that start with `Rubbishsoft.`
