---
title: "What is an \"Application\" in BuildMaster?"
order: 1
---

An application in BuildMaster is connected to a source like a Git Repository or a CI Project. It's used to build and/or deploy a web app, microservice, library packages, containers, or any other kind of project. You can also create controller applications that orchestrate the building, integrating, and deploying of other BuildMaster applications.

Applications contain the scripts, pipelines, triggers, variables, and everything else you need to release your projects from source to production. You can also use applications for security access control by granting and denying tasks to different users across applications.

## Creating a New Application
To create a new application, start by clicking on Create New Application from the Application Selector drop-down menu or navigate to the Applications page and click Create Application. This will open a New Application page that will guide you through creating and configuring an application.

![buildmaster-new-application](/resources/docs/buildmaster-new-application.png){height="" width="50%"}

Selecting Git Repository or CI Project will walk you through the following steps:
1. Creating a connection to a service (GitHub, Jenkins, Azure DevOps, etc.) or using one that you've already created
2. Selecting a Resource (Repository or CI Project) from that service
3. Naming the application
4. (Git only) Selecting the type of code you want to buid (.NET app, Python app, NuGet package, etc.) and how you want to deploy it (server, cloud, etc.)
5. Creating the initial scripts, builds, and pipelines

You can also create a Blank Application, Clone an Application, Create a Sample Application, or use a Legacy [Application Templates](/docs/buildmaster/installation-maintenance/buildmaster-legacy/buildmaster-legacy-application-templates).

## Cloning (Copying) Applications
There are times you may wish to clone (i.e. copy) an application and its settings, such as:
* **Templating**; using an application with a common set of variables and other configuration that can serve as a template for creating new applications
* **Refactoring**; instead of doing a major refactor on an existing application, you can clone it to a new application and modify the new application instead

Cloning will essentially create a backup of the target application, then restore it without history. See [Backing Up & Restoring Applications](/docs/buildmaster/modeling-your-applications/buildmaster-applications-concepts/buildmaster-applications-concepts-backup-restore) to learn more about how this process works. 

## Sample Applications
BuildMaster includes a number of sample applications to help you learn different patterns and practices, from advanced deployment patterns (Blue/Green) to CI/CD for PHP applications.

![buildmaster-sample-applications](/resources/docs/buildmaster-sample-applications.png){height="" width="50%"}

## Deactivating and Purging Applications
You can deactivate or purge applications from Admin > Deactivate and Purge Applications.

Deactivating an application will cancel all of its releases, deactivate automatic builds, and remove it from navigation and other menus throughout BuildMaster, while keeping historical data for the application. You can still access a deactivated application by URL directly.

If you do not wish to keep any data or history for these applications, you may purge them from the system completely.

### Draft Applications
Behind the scenes, when you create an application using a source, an inactive draft application will be created and configured based on the source options you select. Until you name the application, they will have a temporary name like "draft-ah929556c85b7746c0a542498f7a9587aa". 

If you close your browser window without completing the creation steps, these drafts will remain as inactive applications. These draft applications will be automatically purged whenever you upgrade/downgrade BuildMaster.


## Application Groups
Applications may be placed in an application group, which serves a few purposes:
* Visually grouping related applications in the user interface
* Common set of variables across applications
* Permissions that are shared across all applications in the group

Application groups are created from the application settings page by typing in the name of a group that doesn't exist. Empty application groups are automatically deleted.

Once an application group has been created in this manner, you can use that group name when scoping variables (Admin > Variables) or access controls (Admin > Security).

## BuildMaster 7.0 and Earlier

All versions of BuildMaster allow for creating blank applications and cloning existing applications

### BuildMaster 6.2 and BuildMaster 7.0

BuildMaster 6.2 and BuildMaster 7.0 used a combination of [Application Templates](/docs/buildmaster/installation-maintenance/buildmaster-legacy/buildmaster-legacy-application-templates) and [Setup Templates](/docs/buildmaster/installation-maintenance/buildmaster-legacy/buildmaster-applications-concepts-setup-templates) to assist with creating new applications. Clicking Create New Application will navigate to a page that lists:
* Templates that we've built, called Featured Templates and All Templates/Samples
* User Templates that you can create by exporting applications to a template. 

Selecting any of the templates will import the target template and may prompt you to fill out a few more customization settings on the Application Setup page. Application templates are still available in BuildMaster 2022, but are considered a legacy feature.


#### BuildMaster 6.1
Application cloning in BuildMaster 6.1 will not copy any [legacy features](/docs/buildmaster/installation-maintenance/buildmaster-legacy/buildmaster-legacy-features) into the new application. There is a legacy clone feature available under Admin > Legacy Features.

