---
title: "Feeds"
order: 5
---

The Feeds API provides several `pgutil` commands (available as `pgutil feeds`) and HTTP endpoints to query, create, and update [feeds](/docs/proget/feeds/feed-overview), and related data:

## pgutil Commands

All HTTP endpoints of the Feeds API are available as `pgutil` commands. 

To find the list of commands available in `pgutil`, simply run `pgutil feeds --help`. See [Getting started with pgutil](/docs/proget/api/pgutil) to learn more.

## Available HTTP Endpoints

### 📁 Feed Endpoints

* [Create Feed](/docs/proget/api/feeds/create) - creates a specified feed
* [Get Feed](/docs/proget/api/feeds/get) - describes an specified feed
* [List Feeds](/docs/proget/api/feeds/list) - describes all feeds, filtered as specified
* [Update Feed](/docs/proget/api/feeds/update) - updates a specified feed
* [Delete Feed](/docs/proget/api/feeds/delete) - deletes a specified feed

### 🗄 Feed Storage Endpoints

* [Get Feed Storage](/docs/proget/api/feeds/storage-get) - displays a feed's current storage information
* [Update Feed Storage](/docs/proget/api/feeds/storage-update) - updates a feed's storage options
* [List Feed Storage Types](/docs/proget/api/feeds/storage-list) - lists all available types of storage on a ProGet server

## Authenticating to Feeds Management API { #authentication }

The following is a summary of access types and their corresponding requirements for various API keys types and endpoints within this API.

| Access Type | Requirements |
| --- | --- |
| System API Keys | `Use/Manage Feeds` is required for all endpoints 
| Feed API Keys* | `View/Download` is required for all endpoints
| Personal API Key | `Admin_ManageFeed` is required for all endpoints
| No API Key | anonymous or authenticated user must have at least `Feeds_ViewFeed`

*\* Note: A Feed API Key cannot be configured to [Create Feed](/docs/proget/api/feeds/create) or [Delete Feed](/docs/proget/api/feeds/delete).*

To specify an API Key, use the request header (`X-ApiKey`), querystring (`key`), or `api:«api-key»` as the username. See [API Key Usage](/docs/proget/api/apikeys#using-api-keys) to learn more.

:::(Info) (🚀 Quick Example: Authenticating with curl)
For example, to authenticate with the API key `abc12345` to  **List Feeds**, you could specify the API key as follows:

```bash
curl -X GET --header "X-ApiKey: abc12345" "https://proget.corp.local/api/management/feeds/list"
```
:::

## Notes about Data

### Wildcards and Negations

Certain fields noted above support wildcard and negation syntax. For example, the value `["Microsoft.*", "Castle.*", "!Rubbishsoft.*"]` has the following properties:
 - includes any packages that start with `Microsoft.` or `Castle.*`
 - excludes any packages that start with `Rubbishsoft.`

### Feed & Package Types

In the ProGet UI, Chocolatey and PowerShell are represented as separate feed types, even though they only contain NuGet packages and use the same NuGet API. For this reason, in ProGet UI, you can switch the type of a feed' between [NuGet](/docs/proget/feeds/nuget), [Chocolatey](/docs/proget/feeds/chocolatey), and [PowerShell](/docs/proget/feeds/powershell) at any time, but not between other feed types.

The API allows feed types to be changed only within the following feed type groups (anything else generates a `400` error):
 - `universal` and `romp`
 - `nuget`, `chocolatey`, and `powershell`

### Persisted XML Configuration

Because package stores, package filters, and package access rules are implemented by extensible runtime components (i.e., you can create your own using the [Inedo SDK](/docs/inedosdk)), ProGet stores configuration for these components in "Persisted XML", which is a lightweight object serialization format that Inedo products use.

The easiest way to see what an object's persisted XML will look like is to create it in the UI, then look at the XML in either the database or the API [List Feeds](/docs/proget/api/feeds/list) or [Get Feed](/docs/proget/api/feeds/get) request. As a reference, we've provided the persisted XML for both supported package stores and a general example:

#### AWS

```xml
<Inedo.ProGet.Extensions.AWS.PackageStores.S3FileSystem Assembly="AWS">
  <Properties AccessKey="{publicAccessKey}" SecretAccessKey="{privateAccessKey}" BucketName="{bucketName}" TargetPath="{pathInsideBucketDefaultIsRoot}" ReducedRedundancy="{False}" MakePublic="{False}" Encrypted="False" RegionEndpoint="{us-east-1}" CustomServiceUrl="{customServiceUrl}" />
</Inedo.ProGet.Extensions.AWS.PackageStores.S3FileSystem>
```

#### Azure Blob Storage

```xml
<Inedo.ProGet.Extensions.Azure.PackageStores.AzureFileSystem Assembly="Azure">
  <Properties ConnectionString="{DefaultEndpointsProtocol=https;AccountName=account-name;AccountKey=account-key}" ContainerName="{blobContainerName}" TargetPath="{pathToFilesDefaultIsRoot}" />
</Inedo.ProGet.Extensions.Azure.PackageStores.AzureFileSystem>
```

#### Custom Extension Format

```xml
<{FullNamespace.ClassName} Assembly="AssemblyName">
  <Properties PropertyNameA="{property value}" PropertyNameB="1000" />
</{FullNamespace.ClassName}>
```

#### Default Feed Disk Path

If you don't specify a disk path for a feed to use, ProGet uses a path 'based on the 'system-generated ID. This means that, just as in UI, if you delete a feed and then recreate it with the same name, the disk path will be different.