---
title: "Licenses"
order: 10
---

The Licenses API provides several `pgutil` commands (available as `pgutil licenses`) and HTTP endpoints for querying, creating, and updating [licenses](/docs/proget/sca/licenses), and related data:

## pgutil Commands

All HTTP endpoints of the Licenses API are available as `pgutil` commands. 

To find the list of commands available in `pgutil`, simply run `pgutil licenses --help`. See [Getting started with pgutil](/docs/proget/api/pgutil) to learn more.

## Available HTTP Endpoints

* [Create License](/docs/proget/api/licenses/create) - creates a specified license
* [Get License](/docs/proget/api/licenses/get) - describes an specified license
* [List Licenses](/docs/proget/api/licenses/list) - describes all licenses, filtered as specified
* [Update License](/docs/proget/api/licenses/update) - updates a specified license
* [Delete License](/docs/proget/api/licenses/delete) - deletes a specified license

## Authenticating to Licenses Management API { #authentication }

The following is a summary of access types and their corresponding requirements for various API keys types and endpoints within this API.

| Access Type | Requirements |
| --- | --- |
| System API Keys | `Full Control`  is required for all endpoints
| Personal API Key* | `Administer` is required for all endpoints
| No API Key | anonymous or authenticated user must have at least `Administer`

*\* Personal API keys are scoped to users and inherit the [Tasks and attributes](/docs/proget/administration-security#tasks) assigned to those users.*

To specify an API Key, use the request header (`X-ApiKey`), querystring (`key`), or `api:«api-key»` as the username. See [API Key Usage](/docs/proget/api/apikeys#using-api-keys) to learn more.

:::(Info) (🚀 Quick Example: Authenticating with curl)
For example, to authenticate with the API key `abc12345` to **List Licenses**, you could specify the API key as follows:
````
curl -X GET --header "X-ApiKey: abc12345" "https://proget.corp.local/api/licenses/list"
````
:::
