---
title: "Asset Directories"
order: 12
---

The Asset Directories API provides several `pgutil` commands (available as `pgutil assets`) and HTTP endpoints to query, download, publish, delete, and perform other operations on files and folders in an [asset directory](/docs/proget/asset-directories-file-storage/what-is-an-asset-directory). All HTTP requests are made through the following base URL:

:::(info)
 `/endpoints/«AssetDirectoryName»/...`
:::

Asset Directories are represented internally in ProGet as Feeds, so [Feed API keys](/docs/proget/administration-security#api-keys) can be used to authenticate to Asset Directories.

## pgutil Commands

All HTTP endpoints of the Asset Directories API are available as `pgutil` commands. 

To find the list of commands available in `pgutil`, simply run `pgutil assets --help`. See [Getting started with pgutil](/docs/proget/api/pgutil) to learn more.

## Available HTTP Endpoints

The Asset Directories API is comprised of endpoints for both files and folders:

### 📄 File Management { #file-endpoints }

For directly managing the files located in the asset directory. They are designed to function like a standard web server, so hosted files can be accessed by simple GET requests with support for browser caching. 

* [Download Asset File](/docs/proget/api/assets/files/download) - returns the content of a specified file or the files's headers
* [Upload Asset File](/docs/proget/api/assets/files/upload) - uploads a specified file to the asset directory
* [Delete Asset File](/docs/proget/api/assets/files/delete) - deletes a specified file from the asset directory

### 📁 Folder Management { #folder-endpoints }

For managing the folders located in the asset directory.

* [List Asset Folder](/docs/proget/api/assets/folders/list) - describes assets in a specified folder
* [Create Asset Folder](/docs/proget/api/assets/folders/create) - creates a new subfolder
* [Delete Asset Folder](/docs/proget/api/assets/folders/delete) - deletes a specified subfolder
* [Export Asset Folder](/docs/proget/api/assets/folders/export) - exports the contents of a folder as either a `ZIP` or a `TGZ` archive
* [Import Archive](/docs/proget/api/assets/folders/import) - imports the contents of either a `ZIP` or a `TGZ` archive as a subfolder

### 🔖 Metadata Management { #metadata-endpoints }

Allow for reading or updating metadata on a file or folder. Added in ProGet v6.0.0.

* [Get Asset Metadata](/docs/proget/api/assets/metadata/get) - describes the metadata for the specified file or folder
* [Set Asset Metadata](/docs/proget/api/assets/metadata/set) - sets/updates the `Content-Type` or user-defined metadata of a file or folder.

## Authenticating to Asset Directory API { #authentication }

The following is a summary of access types and their corresponding requirements for various API keys types and endpoints within this API.

| Access Type | Requirements |
| --- | --- |
| System API Keys | `Use/Manage Feeds`  
| Feed API Keys | `View/Download` is required for all endpoints<br/>`Add/Repackage` is required for [Upload Asset File](/docs/proget/api/assets/files/upload) and [Import Archive](/docs/proget/api/assets/folders/import)<br/>`Overwrite/Delete` is required for [Delete Asset File](/docs/proget/api/assets/files/delete) and [Delete Asset Folder](/docs/proget/api/assets/folders/delete). 
| Personal API Key | `Feeds_ViewFeed` is required for all endpoints<br/>`Feeds_AddPackage` is required for [Upload Asset File](/docs/proget/api/assets/files/upload) and [Import Archive](/docs/proget/api/assets/folders/import)<br/>`Feeds_DeletePackage` is required for [Delete Asset File](/docs/proget/api/assets/files/delete) and [Delete Asset Folder](/docs/proget/api/assets/folders/delete).
| No API Key | anonymous or authenticated user must have at least `Feeds_ViewFeed`

*\* Personal API keys are scoped to users and inherit the [Tasks and attributes](/docs/proget/administration-security#tasks) assigned to those users.*

To specify an API Key, use the request header (`X-ApiKey`), querystring (`key`), or `api:«api-key»` as the username. See [API Key Usage](/docs/proget/api/apikeys#using-api-keys) to learn more.

:::(Info) (🚀 Quick Example: Authenticating with curl)
For example, to authenticate with the API key `abc12345` to **List Asset Folders**, you could specify the API key as follows:
````
curl -X GET --header "X-ApiKey: abc12345" "https://proget.corp.local/endpoints/internal-files/dir/"
````
:::
