---
title: "Command Overview"
order: 1
---

Romp is a command-line tool used to create and install romp packages.

To begin using Romp simply download and run the installer. Romp will install as a machine-level tool by default, but can also be installed and used as a user-level tool. You can also install the chocolatey Romp package by simply typing `choco install romp`.

## Usage

Romp is invoked as follows:

`romp «command»`

The **command** is one of the following:

#### Creating and Publishing Packages

*   [`pack`](/docs/executionengine/romp-overview/romp-cli-reference/romp-command-line-command-overview/romp-command-line-command-overview-creating-publishing#pack) - Creates a Romp package from the specified directory.
*   [`publish`](/docs/executionengine/romp-overview/romp-cli-reference/romp-command-line-command-overview/romp-command-line-command-overview-creating-publishing#publish) - Publishes the specified package to a package source.

#### Installation, Inspection, and Verification

*   [`install`](/docs/executionengine/romp-overview/romp-cli-reference/romp-command-line-command-overview/romp-command-line-command-overview-installation#install) - Install the specified romp package, unless it's already installed.
*   [`uninstall`](/docs/executionengine/romp-overview/romp-cli-reference/romp-command-line-command-overview/romp-command-line-command-overview-installation#uninstall) - Uninstalls the specified romp package.
*   [`validate`](/docs/executionengine/romp-overview/romp-cli-reference/romp-command-line-command-overview/romp-command-line-command-overview-installation#validate) - Validates a package file on disk to ensure the layout and OtterScript are valid.
*   [`inspect`](/docs/executionengine/romp-overview/romp-cli-reference/romp-command-line-command-overview/romp-command-line-command-overview-installation#inspect) - Validates the package and displays a report of the contents, required variables, and credentials.

#### Package Sources

*   [`sources list`](/docs/executionengine/romp-overview/romp-cli-reference/romp-command-line-command-overview/romp-command-line-command-overview-package-sources#list) - Displays all package sources.
*   [`sources display`](/docs/executionengine/romp-overview/romp-cli-reference/romp-command-line-command-overview/romp-command-line-command-overview-package-sources#display) - Displays all properties of the package source name.
*   [`sources create`](/docs/executionengine/romp-overview/romp-cli-reference/romp-command-line-command-overview/romp-command-line-command-overview-package-sources#create) - Store encrypted resource credentials in Romp's database that can be used from plans.
*   [`sources delete`](/docs/executionengine/romp-overview/romp-cli-reference/romp-command-line-command-overview/romp-command-line-command-overview-package-sources#delete) - Deletes the specified source.
*   [`sources default`](/docs/executionengine/romp-overview/romp-cli-reference/romp-command-line-command-overview/romp-command-line-command-overview-package-sources#default) - Sets the specified source as the default.

#### Romp Configuration

*   [`config list`](/docs/executionengine/romp-overview/romp-cli-reference/romp-command-line-command-overview/romp-command-line-command-overview-romp-configuration#list) - Displays all configuration values after cascading all configuration files.
*   [`config export`](/docs/executionengine/romp-overview/romp-cli-reference/romp-command-line-command-overview/romp-command-line-command-overview-romp-configuration#export) - Exports the current configuration to a configuration file.
*   [`config set`](/docs/executionengine/romp-overview/romp-cli-reference/romp-command-line-command-overview/romp-command-line-command-overview-romp-configuration#set) - Sets a configuration argument in the local configuration file to the specified value.
*   [`config delete`](/docs/executionengine/romp-overview/romp-cli-reference/romp-command-line-command-overview/romp-command-line-command-overview-romp-configuration#delete) - Deletes a configuration value from the local configuration file to revert to the default behavior.

#### Credentials

*   [`credentials list`](/docs/executionengine/romp-overview/romp-cli-reference/romp-command-line-command-overview/romp-command-line-command-overview-credentials#list) - Displays all credential names and type.
*   [`credentials display`](/docs/executionengine/romp-overview/romp-cli-reference/romp-command-line-command-overview/romp-command-line-command-overview-credentials#display) - Displays all properties of the specified credential name.
*   [`credentials store`](/docs/executionengine/romp-overview/romp-cli-reference/romp-command-line-command-overview/romp-command-line-command-overview-credentials#store) - Store encrypted resource credentials in Romp's database that can be used from plans.
*   [`credentials delete`](/docs/executionengine/romp-overview/romp-cli-reference/romp-command-line-command-overview/romp-command-line-command-overview-credentials#delete) - Deletes the specified credential.

#### Auditing Local Machine History

*   [`package list`](/docs/executionengine/romp-overview/romp-cli-reference/romp-command-line-command-overview/romp-command-line-command-overview-auditing#packages-list) - Displays a list of romp packages that have been recorded on the server
*   [`jobs list`](/docs/executionengine/romp-overview/romp-cli-reference/romp-command-line-command-overview/romp-command-line-command-overview-auditing#jobs-list) - Displays a list of recent romp job executions that have been recorded on the server, including their status
*   [`jobs log`](/docs/executionengine/romp-overview/romp-cli-reference/romp-command-line-command-overview/romp-command-line-command-overview-auditing#jobs-logs) - Displays the execution logs for a specified job.
*   [`jobs purge`](/docs/executionengine/romp-overview/romp-cli-reference/romp-command-line-command-overview/romp-command-line-command-overview-auditing#jobs-purge) -Purges jobs older than the specified number of days.