---
title: "Visual Studio Extension (.vsix)"
order: 7
---

A VSIX feed in ProGet stores Visual Studio extensions, which can then be installed directly from Visual Studio.

The Visual Studio gallery uses an internal API that is different from the documented Atom VSIX feed that ProGet provides, so no connector to the Visual Studio Gallery can currently be created in ProGet. However, connectors to other Atom VSIX feeds are supported.

## Prerequisite Configuration

### Adding the Feed to Visual Studio

To add a VSIX feed to Visual Studio, an additional extension gallery must be added. To do this, navigate to "Tools" > "Options" > "Environment" > "Extensions" and click the "Add" button under "Additional Extension Galleries". Fill in the name and set the URL to the API endpoint URL of the VSIX feed.

![options](/resources/docs/visualstudio-options-extensions.png){height="" width="50%"}

This allows you to install the extensions of your VSIX feed in addition to the extensions in the built-in galleries using the "Manage Extensions" window, opened by navigating to "Extensions" > "Manage Extensions".

## Uploading Extensions

To upload a .vsix extension, you can use Inedo's [pgutil](/docs/proget/reference-api/proget-pgutil) and run this command:

```bash
pgutil packages upload --feed=«vsix-feed-name» --input-file=«path-to-extension»
```

For example, to upload the package `myExtension.vsix` located in `C:\visualstudio\extensions` to the feed `internal-vsix` you would enter:

```plaintext
pgutil packages upload --feed=internal-vsix --input-file=C:\visualstudio\extensions\myExtension.vsix
```

pgutil will require some [minor configuration](/docs/proget/reference-api/proget-pgutil#sources) before use.

### ProGet 2023 and earlier

To upload `.vsix` extensions in ProGet 2023 and earlier, you can simply pass the extension to the feed API endpoint URL at `PUT` or `POST`.

```powershell
# PowerShell example
Invoke-RestMethod https://proget.example.com/vsix/FeedName `
-InFile .\MyExtension.vsix `
-Headers @{"Authorization" = "Basic " + [Convert]::ToBase64String([Text.Encoding]::UTF8.GetBytes("api:xxxxxxxxxxxxxx"))}
```

### Bulk Importing Using a Drop Path

ProGet includes [Drop Path](/docs/proget/feeds/feed-overview/proget-bulk-import-with-droppath) support to Vsix feeds. 

## Installing Extensions

### In Visual Studio
Install the extensions of your VSIX feed in addition to the extensions in the built-in galleries [using the "Extension Manager" window](/docs/proget/feeds/vsix/howto-vsix-consume#step-4.1-adding-the-feed-to-visual-studio), opened by navigating to "Extensions" > "Manage Extensions".

![extensions](/resources/docs/visualstudio-extensions-manager.png){height="" width="50%"}

:::(warn)(Authentication in Visual Studio)
Visual Studio does not support authenticated feeds, and will be unable to connect to your feed if your instance of ProGet has built-in authentication enabled. To allow your developers access to view and download packages from your feed through Visual Studio, make sure "Anonymous" access is set up in your ProGet instance. 

![permission](/resources/docs/proget-permissions-vsix.png){height="" width="50%"}
:::

If you want to disable the Visual Studio Marketplace gallery to only show the packages in your private feed you can [disable the public gallery](https://learn.microsoft.com/en-us/visualstudio/extensibility/how-to-manage-a-private-gallery-by-using-registry-settings?view=vs-2022), using a `.pkgdef file`.

### In VS Code
Currently, Visual Studio Code does not support private galleries, despite there being a [request](https://github.com/microsoft/vscode/issues/21839) for it that has been open since 2017. You can still upload extensions to a VSIX feed, but users will need to manually download them from ProGet and then [import them into their Visual Studio Code](/docs/proget/feeds/vsix/howto-vsix-consume#step-4.1-adding-packages-from-a-feed-to-vs-code).

## Software Composition Analysis (SCA)

[SCA](/docs/proget/sca/builds/proget-sca-ci) features in ProGet, including [licensing](/docs/proget/sca/licenses) and [vulnerabilities](/docs/proget/sca/vulnerabilities) are not supported for Visual Studio Extensions packages. This is because feeds are intended for private (first-party) extensions, not ones published on the official gallery. 

This is also a limitation of Visual Studio and VS Code, as you cannot change the public gallery URL. In addition, the API is not documented or supported, nor permitted to be proxied by a tool like ProGet.

While you can upload third-party packages that you've manually downloaded and vetted, ProGet will not display any license or vulnerability information for these packages.