---
title: "Universal Packages"
order: 2
---

There isn't much to a universal package file; there are just two requirements:
1. is a ZIP archive format with a `.upack` file extension
2. has a manifest file in the root directory named `upack.json` with a few required fields

Files in the `/package` directory are called *content* (and are "unpackaged" by the client or server), all other files are *metacontent*.

You can add any number of files or directories outside these minimum requirements - and that's exactly what universal packages are for.

In the <em>extremely unlikely</em> event that a future version of this specification requires or uses additional files (we can think of absolutely no reason why this would ever be required), they'll be specified in the manifest, or possibly given the extension `.upack2`.

## Package Metacontent & Guidance
Files and directories stored outside the `/package` directory of the ZIP archive are called *metacontent*, and the `upack.json` manifest file is the only required metacontent in a package.

Unlike actual content, there is no "general purpose" use case for metacontent. Instead, think of it as a tool that helps you create a specification for a package format based on a universal package. For example, [romp packages](/docs/executionengine/romp-overview/romp-romp-packages) define several metacontent files and folders that are used when installing the `/package` contents.
