---
title: "BuildMaster API Endpoints & Methods"
order: 2
---

There are several API endpoints that you can use to programmatically query or configure BuildMaster instances.

| API | Description |
|------------|-------------------|
| [Application Management](/docs/buildmaster/reference/api/buildmaster-appmanagement-api) | Create, clone, import, update purge and list applications |
| [Infrastructure Management](/docs/buildmaster/reference/api/infrastructure) | Query, create, and update servers, environments, and server roles |
| [Variables Management](/docs/buildmaster/reference/api/variables)                              | View, create, update, and delete configuration variables |
| [Release & Build Deployment](/docs/buildmaster/reference/api/release-and-build)                        | Create and deploy builds or releases |
| [CI Badge](/docs/buildmaster/reference/api/buildmaster-ci-cd-continuous-integration-server-badges) | Generate CI badge images that link back to BuildMaster | 
| [Health](/docs/buildmaster/reference/api/health) | Generate Health Check and version information for your instance of BuildMaster | 

::: (INFO)
If you have any interest in extending these or other endpoints, [please let us know](https://inedo.com/contact)!
:::

## API Keys

Access to any BuildMaster API requires an API key. Refer to the [API Keys documentation](/docs/buildmaster/reference/api/buildmaster-administration-security-api-keys) for more information.

## BuildMaster Native API

The BuildMaster Native API is a lower-level API that effectively wraps the BuildMaster data layer. It's not particularly intuitive, but it's documented here: [BuildMaster Native API Reference](/docs/buildmaster/reference/api/native).