---
title: "Inedo Execution Engine"
order: 3
---

Our products incorporate a shared component called the Inedo Execution Engine. This allows you to automate and orchestrate infrastructure in a consistent way across our products, making it easy to:

* deploy and execute commands across hundreds of servers, simultaneously as needed
* quickly identify what went wrong, using detailed logging with sensitive debugging details hidden from certain users
* use a powerful, but easy-to-learn language called OtterScript while leveraging existing PowerShell and Shell scripts and snippets as needed

As we learned from years of first hand-experience with BuildMaster's [legacy execution](/docs/buildmaster/installation-maintenance/buildmaster-legacy/buildmaster-legacy-features/buildmaster-legacy-plans) engine, there are a lot of "real-world oddities" that you encounter when writing code that will automate and orchestrate infrastructure, such as:

* Sometimes, some things will just work if you retry them a few times in a row
* A "failure" isn't always a failure, but it's important to know
* "Impossible" failures happen all the time
We designed the Inedo Execution Engine from the ground-up to take these, and many more things into consideration --- including lots of research on how many other tools perform automation.