---
title: "Support Tickets"
order: 8
---

Providing support is a central part of our engineers’ jobs. It’s not a burden; it’s a point of pride. Inedo support tickets are simple to open. We are happy to offer additional technical support if our documentation doesn't answer the question you have. 
:::(INFO) (Support tickets are for paid users only.)
We appreciate users of our free software. Our engineers and other users are on the [Inedo Forums](https://forums.inedo.com){target="_blank"} and can help you there. If we can't find a paid license, we will likely ask you to post on the Inedo Forum.
:::

## Submitting a Ticket

Submitting a new ticket is easily done through your MyInedo account by navigating to "Submit Ticket" on the top banner. 

![Submit Ticket Form](/resources/docs/myinedo-supporttickets-submit.png){height="" width="50%"}
Fill out the relevant fields and provide as much detail as possible.

Pay special attention to the **severity type**. When you submit a support ticket to us, you choose the severity. This makes sure “critical” (serious problem) and “blocker” (major malfunction) get resolved ASAP. Carefully read each severity type and choose the one most relevant to your issue:

* **Blocker**- Major malfunction affecting business or high number of staff
* **Critical**- Serious degradation of application performance or functionality
* **Major**- Application issue that moderatly impacts your business
* **Minor**- Minor loss of function or a problem with an easy workaround
* **Trivial**- Cosmetic problem like misspelled words or misaligned text

## Ticket Statuses
A ticket starts in a “Submitted” status. From there, after one of our support engineers assess it, you will receive an automatic email that looks like this:

![Ticket Assigned](/resources/docs/1159-ticket-assigned.png){height="" width="50%"}

The ticket status will then be changed to one of the following:
* **In Progress**- Some form of action is being taken, but there is no resolution yet. 
* **Awaiting Assistance**- Reserved for more complex issues that require brainstorming. 
* **Awaiting Response**- Support staff is waiting on a reply from the user.
* **Awaiting Release**- Support still will follow up with the user after a release. 
* **Closed**- The issues have been addressed or there has been no response in 7 days. 

Once the issue is resolved and the ticket enters a “Closed” status, an email will automatically be dispatched. 

![1159 Ticket Manually Closed](/resources/docs/1159-ticket-manually-closed.png){height="" width="50%"}

## Reviewing & Managing Tickets
Navigate to "My Tickets" to view and manage all current and closed tickets. From here you can update tickets with comments and attachments, review the status of open tickets, and review support for closed tickets. 

![Review Tickets](/resources/docs/ReviewTickets.png){height="" width="50%"}