---
title: "Legacy (Deprecated) Features"
order: 3
url-slug: "buildmaster/installation-maintenance/buildmaster-legacy"
---

Like all DevOps, CI/CD and automation tools on the market, BuildMaster has evolved a lot over the years. The tools and libraries we use have also evolved, allowing us to develop better features with new technologies.

This page is an index of "deprecated" features that we plan to remove from the product in the coming years.

## Legacy Features (Planned for Removal)
A "legacy feature" continues to function as coded, but will one day be removed.

While we continue to support their use, we strongly recommend moving away from them for two reasons:
* **Legacy Features are Fragile**; these features are rarely tested or used in practice, so the likelihood of regressions is higher when we ship new features
* **Legacy Features are Poorly Documented**; many legacy features weren't very well documented to begin with, and existing documentation may be incorrect. Especially if there are navigation instructions or screenshots.

This is a list of the current legacy features:

| Feature | Planned Removal | Replace With |
| --- | --- | --- |
| [Setup Templates](/docs/buildmaster/installation-maintenance/buildmaster-legacy/buildmaster-applications-concepts-setup-templates) | v2024 | *just use the application description* |
| [Application Templates](/docs/buildmaster/installation-maintenance/buildmaster-legacy/buildmaster-legacy-application-templates) | v2024 | [Application Backup / Restore](/docs/buildmaster/modeling-your-applications/buildmaster-applications-concepts/buildmaster-applications-concepts-backup-restore) <br />-or-<br/> *just clone existing application*
| [Variable Value Renderers](/docs/buildmaster/otterscript-execution-engine/buildmaster-variables/buildmaster-variables-customizing-display) | v2024 | [Custom Variable Rendering](/docs/buildmaster/otterscript-execution-engine/buildmaster-variables/buildmaster-variables-customizing-display) |
| [Deployables](/docs/buildmaster/installation-maintenance/buildmaster-legacy/buildmaster-applications-concepts-deployables) | v2025 | [Pipeline Variable Prompts](/docs/buildmaster/otterscript-execution-engine/buildmaster-variables) |
| [Release Templates](/docs/buildmaster/installation-maintenance/buildmaster-legacy/buildmaster-applications-releases-templates) | v2025 |  [Pipeline Variable Prompts](/docs/buildmaster/otterscript-execution-engine/buildmaster-variables) |
| [GitHub & GitLab Webhook Monitors](/docs/buildmaster/installation-maintenance/buildmaster-legacy/buildmaster-legacy-webhooks) | v2025 |  [Git Resource Monitors](/docs/buildmaster/administration/buildmaster-resource-monitors) |
| [Issue Sources](/docs/buildmaster/modeling-your-applications/buildmaster-applications-issue-tracking#buildmaster-2022-and-earlier) | v2025 | [Issue Tracker Projects](/docs/buildmaster/modeling-your-applications/buildmaster-applications-issue-tracking)

## Deprecated (Legacy) Operations
A "deprecated operation" is something that your OtterScript may use. Like legacy features, these will continue to work as coded, but may one day be removed.

| Deprecated Operation | Replacement Operation |
| --- | --- |
| `AzureDevOps::Get-Source`<br/>`Git::Get-Source`<br/>`GitHub::Get-Source`<br/>`GitLab::Get-Source` | `Git::Checkout-Code` |
| `AzureDevOps::Tag`<br/>`Git::Tag`<br/>`GitHub::Tag`<br/>`GitLab::Tag` | `Git::Ensure-Tag` |

Deprecated operations will always give a warning if you use them, and migration is trivial; it only involves changing some OtterScript.

##  Removing Legacy Features
If a "legacy feature" is removed from newer versions of the product, you will not be able to upgrade to the newer version.

However, we will always provide a migration utility that will either migrate the data automatically or guide you on how to do so. This will be available in the final version that includes this feature - and which we will maintain for several years to come.

For example, if you use the "Setup Templates" feature (which will be removed in v2024), you will be prompted in v2023 to stop using it. If you attempt to upgrade to v2024 without taking these steps, the installer will block the installation.

The only features currently removed were developed a long time ago—i.e., before BuildMaster v5 (2016)—and then eventually removed in BuildMaster 6.2 (2020). These are documented in detail at [BuildMaster 6.1 Legacy Features](/docs/buildmaster/installation-maintenance/buildmaster-legacy/buildmaster-legacy-features).
