---
title: "Security"
order: 9
---

The Security API provides several `pgutil` commands (available as `pgutil security`) and HTTP endpoints to create, add, delete, and perform other operations on Users, Groups, Tasks and Permissions. All HTTP requests are made through the following base URL:

:::(info)
 `/api/security/...`
:::

## pgutil Commands

All HTTP endpoints of the Security API are available as `pgutil` commands. 

To find the list of commands available in `pgutil`, simply run `pgutil security --help`. See [Getting started with pgutil](/docs/proget/api/pgutil) to learn more.

## Available HTTP Endpoints

The Security API is comprised of endpoints for Users, Groups, Tasks and Permissions:

### 🙍‍♂️ User Management { #user-endpoints }

For managing Users in ProGet.

* [Create User](/docs/proget/api/security/users/create) - Creates a new User account
* [Edit User](/docs/proget/api/security/users/edit) - Modifies an existing User account
* [Delete User](/docs/proget/api/security/users/delete) - Deletes a User account
* [Show User](/docs/proget/api/security/users/show) - Displays information about a User account*
* [List Users](/docs/proget/api/security/users/list) - Lists User accounts

*\* Only available as a pgutil command.*

### 🏢 Groups Management { #group-endpoints }

For managing user Groups and Group membership in ProGet.

* [Create Group](/docs/proget/api/security/groups/create) - Creates a new Group
* [Delete Group](/docs/proget/api/security/groups/delete) - Deletes a Group
* [List Groups](/docs/proget/api/security/groups/list) - Lists Groups
* [Add Group Member](/docs/proget/api/security/groups/add-member) - Adds a user to a Group*
* [Remove Group Member](/docs/proget/api/security/groups/remove-member) - Removes a user from a Group*
* [List Group Members](/docs/proget/api/security/groups/list-members) - Lists members of a Group*

*\* Only available as a pgutil command.*

### ⚒ Tasks Management { #tasks-endpoints }

For managing and editing Tasks in ProGet, as well as creating, editing and deleting custom Tasks. 

* [Create Task](/docs/proget/api/security/tasks/create) - Creates a ProGet security Task
* [Delete Task](/docs/proget/api/security/tasks/delete) - Deletes a security Task from ProGet
* [List Tasks](/docs/proget/api/security/tasks/list) - Lists security Tasks in ProGet
* [List Task Attributes](/docs/proget/api/security/tasks/list-attributes) - List available security Task attributes

### 🔑 Permissions Management { #permissions-endpoints }

For managing the Permissions of Users and Groups in ProGet. 

* [Add Permission](/docs/proget/api/security/permissions/add) - Adds a Permission
* [Remove Permission](/docs/proget/api/security/permissions/remove) - Removes a Permission
* [List Permissions](/docs/proget/api/security/permissions/list) - Lists configured Permissions

## Authenticating to Security API { #authentication }

The following is a summary of access types and their corresponding requirements for various API keys types and endpoints within this API. Note that Feed API keys cannot be used to authenticate to this API.

| Access Type | Requirements |
| --- | --- |
| System API Keys | `Full Control` is required for all endpoints
| Personal API Keys** | `Admin_ConfigureProGet` is required for all endpoints

*\** Personal API keys are scoped to users and inherit the [Tasks and attributes](/docs/proget/administration-security#tasks) assigned to those users.

To specify an API Key, use the request header (`X-ApiKey`), querystring (`key`), or `api:«api-key»` as the username. See [API Key Usage](/docs/proget/api/apikeys#using-api-keys) to learn more.

:::(Info) (🚀 Quick Example: Authenticating with curl)
For example, to authenticate with the API key `abc12345` to **List Users**, you could specify the API key as follows:
````
curl -X GET --header "X-ApiKey: abc12345" "https://proget.corp.local/api/security/users/list/"
````
:::