---
title: "Java"
order: 2
---

[Java](https://www.java.com/) is one of the top five programming languages in the software ecosystem, running on billions of devices from global cloud systems to single-board computers like Raspberry Pi. 

[Jakarta EE](https://jakarta.ee/) is the de facto set of multi-tier specifications and extensions to Java SE that enables enterprise application services such as:

 - Servlets
 - JavaServer Faces (JSF) *(component-based UI for web apps)*
 - Web services
 - Framework libraries and APIs:
   - Dependency injection
   - Persistence
   - Transactions

Formerly known as Java Enterprise Edition (Java EE) and Java 2 Platform, Enterprise Edition (J2EE), it is sponsored by the [Eclipse Foundation] and contributed to by Oracle.

The most common Java application servers are: 


 - [Apache TomEE](/docs/buildmaster/development-platforms/buildmaster-platforms-java/deploying-java-applications-to-tomcat)
 - [Red Hat WildFly](/docs/buildmaster/development-platforms/buildmaster-platforms-java/buildmaster-platforms-java-wildfly) (formerly JBoss Application Server) 
 - [JBoss Enterprise Application Platform (EAP)](/docs/buildmaster/development-platforms/buildmaster-platforms-java/buildmaster-platforms-java-wildfly) (paid version of WildFly)
 - [Oracle WebLogic](https://www.oracle.com/middleware/technologies/weblogic.html)
 - [Eclipse Glassfish](https://projects.eclipse.org/proposals/eclipse-glassfish) (formerly Oracle)
 - [IBM WebSphere](https://www.ibm.com/cloud/websphere-application-platform/)

When deploying Java locally or to small web servers, the most common web servers are:

 - [Eclipse Jetty](/docs/buildmaster/development-platforms/buildmaster-platforms-java/buildmaster-platforms-java-jetty)
 - [Apache Tomcat](/docs/buildmaster/development-platforms/buildmaster-platforms-java/deploying-java-applications-to-tomcat)

## Building Java Applications 

Java programs are compiled into bytecode as `.class` files and packaged into one of many types of [JAR files](https://docs.oracle.com/javase/tutorial/deployment/jar/basicsindex.html). At run time, bytecode is interpreted and executed by the Java Virtual Machine ([JVM](https://docs.oracle.com/javase/specs/jvms/se13/html/jvms-1.html#jvms-1.2)). To develop Java, you'll always develop against the [Java Development Kit (JDK)](https://www.oracle.com/java/technologies/javase-jdk13-doc-downloads.html).

Common tools used to build and test Java programs are:

 - [**javac**](https://docs.oracle.com/en/java/javase/13/docs/specs/man/javac.html) - primary Java compiler included with the JDK
 - [**Maven**](/docs/buildmaster/development-platforms/buildmaster-platforms-java/buildmaster-platforms-java-maven) - most common XML-based build and deployment tool with all the support of Ant plus dependency management, packaging, publish support
 - [**Ant**](/docs/buildmaster/development-platforms/buildmaster-platforms-java/buildmaster-platforms-java-ant) - basic build tool with customizable XML build tasks
 - [**Gradle**](/docs/buildmaster/development-platforms/buildmaster-platforms-java/buildmaster-platforms-java-gradle) - similar to Maven but uses a [Groovy](http://groovy-lang.org/)-based configuration file
 - [**JUnit**](/docs/buildmaster/development-platforms/buildmaster-platforms-java/buildmaster-platforms-java-junit) - most common unit test framework for Java applications

## Automation with BuildMaster 

At a high level, the process of building and deploying Java applications with BuildMaster is:

 - Get source code from the source control repository
 - Compile project with Maven
 - Capture artifact for deployment

## Deploying Java Applications 

Java applications in an enterprise are typically deployed on premise or to hosted application servers such as:

 - IBM WebSphere
 - Oracle WebLogic
 - Red Hat JBoss/WildFly
 - Tomcat

Deployment to application servers involves running a host-specific deploy command on a remote server, typically with a WAR file as an input argument.

Deploying to web servers is a little different. Deploying to Tomcat servers, for example, follows the common format:

 - Stop Tomcat services
 - Deploy WAR file
 - Start Tomcat services