---
title: "Notifications & Webhooks"
order: 6
---

Notifiers can alert you via email, Slack, or Teams when new vulnerabilities are detected, a noncompliant package is discovered, and when other package-related events occur. You can also configure webhooks to send these alerts, trigger automation workflows, externally audit certain events, etc.

:::(Info) (🔒 ProGet Enterprise Feature)
ProGet Notifiers and Webhooks are not available in ProGet Free Edition, and ProGet Basic Edition supports only custom webhooks (not emails). See [License Restrictions](/docs/proget/administration/license) to learn more.
:::


## Creating a Notifier
To create a notifier, navigate to  Admin > Notifiers & Webhooks, then click "Create Notifier".

![Custom Webhooks](/resources/docs/proget-notifiers-create.png){height="" width="50%"}

After selecting the Event type (such as New Vulnerability Detected or Package Promoted) and then Action (such as Send an email or Custom webhook), you'll be presented with additional relevant options. You can also specify *Conditions* to determine whether the notifier should run on all feeds, for specific packages, etc.

### Prerequisite Configuration
Before configuring an Email, Slack, or Teams notification, you may need to make some configuration changes.

| Action | Required Configuration  |
|--------|----------------|
| Send an Email  | In ProGet, configure mail server settings under Advanced > SMTP Settings |
| Slack message  | In Slack, create an Incoming Webhook Application; see [HOWTO: Send notifications to Slack](/docs/proget/administration/proget-notifications-webhooks/proget-notifiers-slack-integration) |
| Teams message  | In Teams, create an Incoming Webhook in the desired channel; see [HOWTO: Send notifications to Teams](/docs/proget/administration/proget-notifications-webhooks/proget-notifiers-teams-integration) |
| Custom webhook | None required |

Once the prerequisite configuration is complete, you'll be able to use notifiers.

## Notifications & Event Types { #events }
There are two categories of events that you can create a notifier for.

### Package Events

These occur immediately after a package is added, removed, or changed on a feed. 

| Package Event  | Notes          |
|----------------|----------------|
| Added | does not occur if the package is being automatically cached from a connector |
| Overwritten | when the package already exists on feed, this occurs instead of Added |
| Promoted  | this occurs instead of Added when  the package is added to the feed via [package promotion](/docs/proget/packages/package-promotion) |
| Deployed | occurs when a [package deployment record](/docs/proget/packages/package-deployment) is added |
| Deleted | does not occur if the package is cached from a connector  |
| Purged | when the package is deleted using [retention rules](/docs/proget/administration/retention-rules), this occurs instead of Deleted |
| Status Changed | occurs when a non-cached package is listed, deprecated, etc. |

These events are nearly the same as the audit events (under Admin > Event Log), except audit events will include cached packages.

If for some reason you'd like to also send notifications for cached packages, just [let us know via the support channel](https://inedo.com/support). It's easy to change, but we'd like to document why to use them.

### SCA Events

These occur immediately after a noncompliant or vulnerable package is added to a feed or issues are created in a noncompliant build. SCA events  can also occur during the continuous (generally overnight) scanning of packages and builds.

| SCA  Event  | Notes          |
|----------------|----------------|
| Noncompliant Package Discovered | this may occur shortly after a package was added to a feed or while running the ComplianceAnalyzer scheduled job (typically overnight), and indicates that an analysis using relevant  [package policies](/docs/proget/sca/policies) yielded a Noncompliant result  |
| New Vulnerability Detected | this may occur shortly after a package was added to a feed or while running the VulnerabilityDatabaseUpdater scheduled job (typically overnight)
| Issues Opened on Build | this may occur after a build was manually or automatically analyzed while running the  ComplianceAnalyzer scheduled job (typically overnight), and [build issues](/docs/proget/sca/builds) were created/reopened as a result |


## Conditionally Send Notifications
The "Conditions" tab of a notifier allows you to control whether a notification will be dispatched (sent).

![Webhook Conditions](/resources/docs/proget-notifiers-conditions.png){height="" width="50%"}

When "Run on feed" is selected, notifications will only be dispatched for events that occur on the feed. Note that when selecting a feed for events that don't relate to feeds (such as Issues Opened on Build), a notification will never be dispatched.

You can also select "Run conditionally", which will allow you to further control if a notification is dispatched. 
* **Always run** is the default, and will run when the feed condition matches
* **Never run** disables the notifier and is a convenient alternative to deleting them
* **Package matches** will limit dispatch to a package name or package version
* **Vulnerability score** will limit dispatch if the vulnerability score is at least as high 
* **Advanced expression** allows you to use OtterScript and variables to control dispatch

To learn more about how to use OtterScript with advanced expressions, see Variables under [Creating Custom Webhooks](/docs/proget/administration/proget-notifications-webhooks/proget-notifications-custom-webhook).

## Custom Webhooks

ProGet's custom webhooks allow you to control nearly all aspects of the dispatched request.

![Custom Webhooks](/resources/docs/proget-notifiers-custom-webhook.png){height="" width="50%"}

By default, the Request Type (i.e. HTTP Method) will be `POST`, and the Headers will be `Content-Type: application/json`. The Content (i.e. Body or Payload) will depend on the event type, and can written using an OtterScript expression. See [Creating Custom Webhooks](/docs/proget/administration/proget-notifications-webhooks/proget-notifications-custom-webhook) to see these defaults.

### Default Content: Issues Opened on Build 

<table><tr><th>OtterScript</th><th>Example Output</th></tr>
<tr><td><pre>
$ToJson(%(
    issues: @BuildIssues,
    buildNumber: $BuildNumber,
    releaseNumber: $BuildReleaseNumber,
    projectName: $BuildProjectName
))
</pre></td><td><pre>
{
  "issues": [ 
    {"Sequence": "1", "Detail":"Noncompliant package (PGV-892418)" }, 
    {"Sequence":"4", "Detail":"Noncompliant package (MIT License)"} ],
  "buildNumber": "25.4.2",
  "releaseNumber": "v25-Q4",
  "projectName": "XAPUtil.Web" 
}
</pre></td></tr></table>


### Default Content: Noncompliant Package Detected 

<table><tr><th>OtterScript</th><th>Example Output</th></tr>
<tr><td><pre>
$ToJson(%(
    package: $PackageId,
    version: $PackageVersion,
    result: $PackageComplianceResult,
    details: $PackageComplianceDetails,
    feed: $FeedName
))
</pre></td><td><pre>
{
  "package": "MyCorp.CoolUtils",
  "version": "3.2.0-pre.1",
  "result": "Noncompliant",
  "details": "Vulnerability (PGV-2358804); Package is Unlisted",
  "feed": "internal-utils"
}
</pre></td></tr></table>

### Default Content: New Vulnerability Detected

<table><tr><th>OtterScript</th><th>Example Output</th></tr>
<tr><td><pre>
$ToJson(%(
    packages: @AffectedPackages,
    vulnerabilityId: $VulnerabilityId,
    summary: $VulnerabilitySummary,
    severity: $VulnerabilitySeverity,
    score: $VulnerabilityScore
))
</pre></td><td><pre>
{
  "packages": [ {"Name": "nuget:Newtonsoft.Json", "AffectedVersions":"&lt; 13.0.1." } ]
  "vulnerabilityId": "PGV-2245804",
  "summary": "Improper Handling of Exceptional Conditions in Newtonsoft.Json",
  "severity": "High",
  "score": "7.5"
}
</pre></td></tr></table>

### Default Content: Package Events

<table><tr><th>OtterScript</th><th>Example Output</th></tr>
<tr><td><pre>
$ToJson(%(
    package: $PackageId,
    version: $PackageVersion,
    event: $WebhookEvent,
    user: $UserName,
    feed: $FeedName
))  
</pre></td><td><pre>
{
  "package": "MyCorp.CoolUtils",
  "version": "3.2.0-pre.1",
  "event": "Promoted",
  "user": "API",
  "feed": "internal-utils"
}
</pre></td></tr></table>

## Troubleshooting

To help with troubleshooting, ProGet stores history about the last 50 dispatch results for each notifier. You can see these under Admin > Notifiers > View Logs. 

:::(Internal)
Screenshot and perhaps explain what fields mean
:::

### Dispatch Mechanisms

Understanding how notifications are dispatched may help troubleshoot errors related to network issues, firewalls, etc.

Notifications may be dispatched from either the ProGet Web Application or the ProGet Service, depending on how the event occurred. For example, promoting a package can only be done from the Web Application (i.e. UI or API), so a notification will always be dispatched from the Web. However, a Package Add may occur from the Web Application *or also* the Service, since the drop path monitor can also add packages.


## ProGet 2023 and earlier

ProGet 2023 and earlier versions have a webhooks feature that behaves similarly.

* Everything is basically a "Custom webhook", and emails are not supported
* There is no dispatch history, but you can view errors by navigating to Administration>  Diagnostics Center and filtering to show only webhook messages
* Slack and teams messages are supported but more complicated (see [Connecting to Slack (archive.org)](https://web.archive.org/web/20230927142242/https://docs.inedo.com/docs/proget-advanced-webhooks-webhooks-slack))

See the [Webhooks (archive.org)](https://web.archive.org/web/20230927142242/https://docs.inedo.com/docs/proget-advanced-webhooks) documentation to learn more.

There was also a [Webhooks Management API (archive.org)](https://web.archive.org/web/20230325005927/https://docs.inedo.com/docs/proget-reference-api-webhook) that has been discontinued. 
