---
title: "Security and Access Controls"
order: 9
---

Security and access control policies are defined by granting principals (users or groups) permission to perform specific tasks in a specific scope (feed specific, feed group specific, or global).

For example, you can specify "The 'HDARS Developers' group is allowed to publish packages to the 'Dev' feed group", which would allow all users in that group to publish packages to all Dev feeds.

::: (INFO)
Scoping is only available in paid and trial ProGet editions; feed groups are available from ProGet v6. 
:::

Principals are defined in a user directory that is either internal (i.e., integrated with ProGet) or external (such as Active Directory and LDAP). This allows you to create a single sign-on experience while allowing other members of the organization to manage user accounts and group memberships.

You can also restrict principals from performing tasks, such as "The 'Developer' group is not allowed to publish packages in the 'Restricted' feed." These overlapping rules, as well as externally defined user directories, can be used to model granular access control policies.

## Tasks 

ProGet ships with five tasks:

|Task|Description|
|--- |--- |
|Administer|Full control over the ProGet instance|
|Manage Feed|Allows access to manage feed settings, delete packages, and overwrite packages.|
|Promote Packages| Allows  access to promoting packages to a specific feed of the same feed type. Users assigned this task should also be given at least the View and Download Packages task for the source feed.|
|Publish Packages| Allows access to publish, upload, push, and pull packages from a feed.|
|View and Download Packages| Allows access to viewing and downloading packages from a feed.|


### Adding Permissions and Restrictions 

Tasks are assigned to principals by adding or deleting permissions (permissions or restrictions) on the Admin > Security > Tasks page. Permissions consist of the following elements:

* Principal - either a user or a group
* Scope - a specific feed, a feed group or all feeds
* Task - what the principal is allowed to do (or not do)

### Task Resolutions

Because you can define both permissions and restrictions at multiple scoping levels, determining whether a user is allowed to perform a particular action can be quite complex. In general, ProGet uses the following guidelines to resolve tasks:

1. More specific permissions take precedence over less specific ones
2. Restrictions take precedence over permissions

For example, consider the following set of rules:

1. The "developer" group is allowed to "promote packages."
2. The "developer" group is not allowed to promote packages to a "production" feed

A more natural way to describe this in English might be:

_Developers are allowed to promote packages from any feed except the production feed._

In this case, the restriction (rule 2) applies only to the Production feed, and in this case it takes precedence over the first permission (rule 1).

### Specific Algorithm  

All grants that would apply to the demand attribute (e.g., view project, deploy package, etc.) for the specified range (i.e., specific feed or all feeds) are combined into a list and then sorted by comparing the range of each rule to the following priority.

* User
* Feed & Feed Group
* Restriction

For example, a user-specific rule is sorted over a feed-specific rule. The first rule is then used; if it is a permission, the user is allowed to perform the requested action.

## User Directories

A user directory is a collection of users and groups that ProGet can query. They are extensible (which means you can write your own), and ProGet comes with two directories:

* **Built-In** - The default user account system used by new installations of ProGet
* **Active Directory (LDAP)** - Users and groups from an LDAP (Active Directory) directory are used; these can come from multiple domains in an Active Directory forest.

Task permissions and restrictions are associated with a user directory, which means that "bob-smith" from the built-in directory does not necessarily have the same permissions as "bob-smith" from the Active Directory.

### Configuring Multiple Directories / Domains

:::(Info)
This functionality describes functionality starting in ProGet 2022, BuildMaster 2022, and Otter 2022. This is is available as a preview feature in ProGet 6.0.8+.
:::

You can configure as many user directories as you need and enable the directories you want to search. If there are multiple enabled user directories, they will all be used to search for users/groups and verify logins.

For example, if `mycompany.corp` and `trusteddomain.corp` are both configured, and the Built-in User Sign-on is Enabled:

 * If you enter `jdoe` in a search box then you may see:
   * `jdoechestor` (from the Built-in Users)
   * `jdoeson@mycompany.corp`
   * `jdoe@trusteddomain.corp`
   * `jdoedawn@trusteddomain.corp`
 
 * When a user logs in with `jdoe` and `hunter42`
   * the Built-in Users will be used to validate the login, and if that fails...
   * the `mycompany.corp` domain will be used, but if that fails...
   * the `trusteddomain.corp` domain will be used
   * the user will get an "invalid login" error if they all fail

As a result, this behavior may yield to logging of failed logins. The exception to behavior is if the username contains a `@` or `\` symbol, such as `jdoe@mycompany.corp` or `COMPAN\jdoe`. In that case, only the domains that matching that name searched.

#### Hybrid User Directory
Prior to ProGet 2022, BuildMaster 2022, and Otter 2022, you could create a [Hybrid User Directories](/docs/installation/security-ldap-active-directory/legacyconfigurations/various-ldap-combining-with-built-in) to approximate this behavior.

Upon upgrading to these versions, the Hybrid User Directory will be removed and the associated directories will be enabled.

## Built In Directory 

ProGet's built-in user directory is used by default and initially contains a single user with the username "Admin" and password "Admin". You can add additional users and groups to this directory using the Admin > Security > Users page.

### Active Directory LDAP 

This is common to all of our products; check out the [shared documentation](/docs/installation/security-ldap-active-directory/various-ldap-ldap-active-directory).

## Virtual Privilege Assignments

As of ProGet v5.2.5, privileges may be granted or restricted for the following catch-all principals in any user directory:

 - **Everyone** - all users with network access to the system, whether authenticated or not
 - **Authenticated** - all users who have provided valid credentials
 - **Anonymous** - all unauthenticated users with network access to the system (i.e., who have not logged in)