---
title: "Legacy Configurations"
order: 7
---

:::(Error) (Deprecated Feature / Outdated Documentation)
This describes the behavior of ProGet 6.0, BuildMaster 7.0, Otter 3.0, and earlier. 
:::

Only one user directory can be active at a time: either the built-in one or one of the configured LDAP/AD directories for querying.

This approach has some disadvantages:

 * It is easy to get locked out; if there is a configuration problem, you must follow the reset instructions to fix it
 * Migration of domains is tedious; because each of these directories uses its own permissions, if you want to configure a different user directory, you must recreate all of those permissions


### Hybrid User Directory (Legacy)
Prior to ProGet 2022, BuildMaster 2022, and Otter 2022, you could create a [Hybrid User Directories](/docs/installation/security-ldap-active-directory/legacyconfigurations/various-ldap-combining-with-built-in) to approximate this behavior.

Upon upgrading to these versions, the Hybrid User Directory will be removed and the associated directories will be enabled.

### v4: Active Directory / LDAP (Legacy)

This was an improvement to v3 to optimize the LDAP queries, better support for side-by-side user directories, allow for more LDAP customizations, and add better support for other LDAP queries.  It also added an Active Directory only recursive search improvement that is more efficient than the previous LDAP recursive search.  This user directory has been deprecated and split into two user directories: **[Active Directory (v5)](/docs/installation/security-ldap-active-directory/various-activedirectory-v5-advanced)** and **[OpenLDAP/Generic LDAP](/docs/installation/security-ldap-active-directory/various-ldap-openldap)**.

See [Advanced Configuration (v4)](/docs/installation/security-ldap-active-directory/legacyconfigurations/various-ldap-v4-advanced) to learn more.

### v3: Active Directory / LDAP (Legacy)

This was a complete rewrite that effectively combines the concepts of v1 and v2. It can search multiple domains (each with different credentials) and provides several AD -specific features such as the ability to search gMSA accounts.

See [Advanced Configuration (v3)](/docs/installation/security-ldap-active-directory/legacyconfigurations/various-ldap-v3-advanced) to learn more.

### v2: Active Directory Domain Forest (Legacy)

This fixed a major bug in v1: It only queried a single domain, which was a problem for organizations that wanted to enroll users from multiple domains. This user directory removed the unnecessary field matching and searched all domains in an Active Directory forest instead of performing LDAP queries for one domain.

### v1: LDAP or Single Domain Active Directory (Legacy)

This worked for most customers who only wanted to authenticate via LDAP or integrate into a single domain. It allowed custom mapping of LDAP property names... which in hindsight wasn't necessary. All the directories we saw in practice followed the same conventions.
