---
title: "Feeds"
order: 5
---

The Feeds API provides several `pgutil` commands (available as `pgutil feeds`) and HTTP endpoints to query, create, and update [feeds](/docs/proget/feeds/feed-overview), and related data:

## pgutil Commands

All HTTP endpoints of the Feeds API are available as `pgutil` commands. 

To find the list of commands available in `pgutil`, simply run `pgutil feeds --help`. See [Getting started with pgutil](/docs/proget/api/pgutil) to learn more.

## Available HTTP Endpoints

### 📁 Feed Endpoints

* [Create Feed](/docs/proget/api/feeds/create) - creates a specified feed
* [Get Feed](/docs/proget/api/feeds/get) - describes an specified feed
* [List Feeds](/docs/proget/api/feeds/list) - describes all feeds, filtered as specified
* [Update Feed](/docs/proget/api/feeds/update) - updates a specified feed
* [Delete Feed](/docs/proget/api/feeds/delete) - deletes a specified feed

### 🗄 Feed Storage Endpoints

* [Get Feed Storage](/docs/proget/api/feeds/storage-get) - displays a feed's current storage information
* [Update Feed Storage](/docs/proget/api/feeds/storage-update) - updates a feed's storage options
* [List Feed Storage Types](/docs/proget/api/feeds/storage-list) - lists all available types of storage on a ProGet server

## Authenticating to Feeds Management API { #authentication }

The following is a summary of access types and their corresponding requirements for various API keys types and endpoints within this API.

| Access Type | Requirements |
| --- | --- |
| System API Keys | `Use/Manage Feeds`  
| Feed API Keys | `View/Download` is required for all endpoints<br/>`Add/Repackage` is required for [Create Feed](/docs/proget/api/feeds/create)<br/>`Overwrite/Delete` is required for [Delete Feed](/docs/proget/api/feeds/delete)
| Personal API Key | `Feeds_ViewFeed` is required for all endpoints<br/>`Feeds_AddPackage` is required for the [Create Feed](/docs/proget/api/feeds/create)<br/>`Feeds_DeletePackage` is required for the [Delete Feed](/docs/proget/api/feeds/delete)
| No API Key | anonymous or authenticated user must have at least `Feeds_ViewFeed`

To specify an API Key, use the request header (`X-ApiKey`), querystring (`key`), or `api:«api-key»` as the username. See [API Key Usage](/docs/proget/api/apikeys#using-api-keys) to learn more.

:::(Info) (🚀 Quick Example: Authenticating with curl)
For example, to authenticate with the API key `abc12345` to  **List Feeds**, you could specify the API key as follows:

```bash
curl -X GET --header "X-ApiKey: abc12345" "https://proget.corp.local/api/management/feeds/list"
```
:::

## Data Specifications { #data-specifications }

### ProgetFeed Object Attributes { #feed-object }

`ProgetFeed` is a JSON object (see [ProgetFeed.cs](https://github.com/Inedo/pgutil/blob/thousand/Inedo.ProGet/ProGetFeed.cs)) that corresponds to the fields on a feed. It's used as input for [Create Feed](/docs/proget/api/feeds/create) and [Update Feed](/docs/proget/api/feeds/update), and output for [Get Feed](/docs/proget/api/feeds/get) and [List Feeds](/docs/proget/api/feeds/list).

`name` and `feedType` properties are required for [Create Feed](/docs/proget/api/feeds/create). Unless otherwise indicated, omitting a property or supplying `null` as the value will keep the current setting.

#### Example JSON Object:

```json
{
   "name":"myNugetFeed",
   "alternateNames":[],
   "feedType":"nuget",
   "active":true,
   "cacheConnectors":true,
   "symbolServerEnabled":false,
   "stripSymbols":false,
   "stripSource":false,
   "endpointUrl":"https://proget.corp.local/nuget/public-nuget/v3/index.json",
   "connectors":["nuget.org"],
   "retentionRules":[],
   "variables":{},
   "canPublish":true,
   "packageStatisticsEnabled":false,
   "restrictPackageStatistics":false,
   "deploymentRecordsEnabled":true,
   "usageRecordsEnabled":true,
   "vulnerabilitiesEnabled":true,
   "licensesEnabled":true,
   "useWithProjects":true
}
```

Nuget Packages Only:

```json
{
  "symbolServerEnabled": true,
  "stripSymbols": false,
  "stripSource": true,
  "stripSignature": false,
  "useApiV3": true
}
```

### RetentionRule Object Attributes { #retention-object }

`RetentionRule` is a JSON object (see [RetentionRule.cs](https://github.com/Inedo/pgutil/blob/thousand/Inedo.ProGet/RetentionRule.cs)), used as a parameter on a [ProgetFeed.cs](https://github.com/Inedo/pgutil/blob/thousand/Inedo.ProGet/ProGetFeed.cs) object. It corresponds to the fields on a Retention rule and is used as input for [Update Feed](/docs/proget/api/feeds/update), and output for [Get Feed](/docs/proget/api/feeds/get) and [List Feeds](/docs/proget/api/feeds/list).

#### Example JSON Object

```json
{
  "deletePrereleaseVersions": false,
  "deleteCached": true,
  "keepVersionsCount": 5,
  "keepUsedWithinDays": 30,
  "triggerDownloadCount": 100,
  "keepPackageIds": ["package1", "package2"],
  "deletePackageIds": [],
  "keepVersions": ["1.0.0", "2.0.0"],
  "deleteVersions": [],
  "sizeTriggerKb": 1024,
  "sizeExclusive": true
}
```

### FeedStorageConfiguration Object Attributes { #storage-object }

`FeedStorageConfiguration` is a JSON object (see [FeedStorageConfiguration.cs](https://github.com/Inedo/pgutil/blob/thousand/Inedo.ProGet/FeedStorageConfiguration.cs)) used as input for [Update Feed Storage](/docs/proget/api/feeds/storage-update), and output for [Get Feed Storage](/docs/proget/api/feeds/storage-get).

#### Example JSON Object
```json
{
  "id": "disk",
  "properties": {
    "StoragePath": null
  }
}
```

### FeedStorageType Object Attributes { #type-object }

`FeedStorageType` is a JSON object (see [FeedStorageType.cs](https://github.com/Inedo/pgutil/blob/thousand/Inedo.ProGet/FeedStorageType.cs)) used as output for [List Feed Storage Types](/docs/proget/api/feeds/storage-list).

#### Example JSON Object

```json
{
"id": "azure",
"name": "Microsoft Azure",
"description": "A file system backed by Microsoft Azure Blob Storage.",
"properties": {
    "ConnectionString": {
    "required": true,
    "name": "Connection string",
    "description": "A Microsoft Azure connection string"
    },
    "ContainerName": {
    "required": true,
    "name": "Container",
    "description": "The name of the Azure Blob Container"
    },
    "TargetPath": {
    "name": "Target path",
    "description": "The path in the specified Azure Blob Container"
    }
  }
},
```

## Notes about Data

### Wildcards and Negations

Certain fields noted above support wildcard and negation syntax. For example, the value `["Microsoft.*", "Castle.*", "!Rubbishsoft.*"]` has the following properties:
 - includes any packages that start with `Microsoft.` or `Castle.*`
 - excludes any packages that start with `Rubbishsoft.`

### Feed & Package Types

In ProGet UI, Chocolatey and PowerShell are represented as separate feed types, even though they only contain NuGet packages and use the same NuGet API. For this reason, in ProGet UI, you can switch the type of a feed' between [NuGet](/docs/proget/feeds/nuget), [Chocolatey](/docs/proget/feeds/chocolatey), and [PowerShell](/docs/proget/feeds/powershell) at any time, but not between other feed types.

The API allows feed types to be changed only within the following feed type groups (anything else generates a `400` error):
 - `universal` and `romp`
 - `nuget`, `chocolatey`, and `powershell`

### Persisted XML Configuration

Because package stores, package filters, and package access rules are implemented by extensible runtime components (i.e., you can create your own using the [Inedo SDK](/docs/inedosdk)), ProGet stores configuration for these components in "Persisted XML", which is a lightweight object serialization format that Inedo products use.

The easiest way to see what an object's persisted XML will look like is to create it in the UI, then look at the XML in either the database or the API [List Feeds](/docs/proget/api/feeds/list) or [Get Feed](/docs/proget/api/feeds/get) request. As a reference, we've provided the persisted XML for both supported package stores and a general example:

#### AWS

```xml
<Inedo.ProGet.Extensions.AWS.PackageStores.S3FileSystem Assembly="AWS">
  <Properties AccessKey="{publicAccessKey}" SecretAccessKey="{privateAccessKey}" BucketName="{bucketName}" TargetPath="{pathInsideBucketDefaultIsRoot}" ReducedRedundancy="{False}" MakePublic="{False}" Encrypted="False" RegionEndpoint="{us-east-1}" CustomServiceUrl="{customServiceUrl}" />
</Inedo.ProGet.Extensions.AWS.PackageStores.S3FileSystem>
```

#### Azure Blob Storage

```xml
<Inedo.ProGet.Extensions.Azure.PackageStores.AzureFileSystem Assembly="Azure">
  <Properties ConnectionString="{DefaultEndpointsProtocol=https;AccountName=account-name;AccountKey=account-key}" ContainerName="{blobContainerName}" TargetPath="{pathToFilesDefaultIsRoot}" />
</Inedo.ProGet.Extensions.Azure.PackageStores.AzureFileSystem>
```

#### Custom Extension Format

```xml
<{FullNamespace.ClassName} Assembly="AssemblyName">
  <Properties PropertyNameA="{property value}" PropertyNameB="1000" />
</{FullNamespace.ClassName}>
```

#### Default Feed Disk Path

If you don't specify a disk path for a feed to use, ProGet uses a path 'based on the 'system-generated ID. This means that, just as in UI, if you delete a feed and then recreate it with the same name, the disk path will be different.
