---
title: "Invoices & Payments"
order: 6
---

This article will cover how to access your quotes & invoices through MyInedo as well as the payment methods accepted by Inedo.  To create a quote, see [purchasing a license](/docs/myinedo/purchasing-license) or [renewing a license](/docs/myinedo/renewing-license).

## Accessing your Quote/Invoice

To access your quote or invoice through MyInedo, simply click on "My Invoices" at the top of the MyInedo webpage. You will then be shown all your existing quotes and invoices. To pay a quote and have an invoice generated click "pay now" next to the relevant quote.

![Pay Invoice](/resources/docs/myinedo-payments-accessinvoice.png){height="" width="50%"}
After selecting your payment method and filling out the appropriate fields, an invoice will be generated.

## Payment Methods
MyInedo accepts most standard payment methods including credit card, purchase order (PO), check, and bank transfer. 

## Credit Card
Credit card payments are processed securely through [Stripe Checkout](https://stripe.com/en-gb-jp/payments/checkout){target="_blank"}, our third-party credit-card payment service. 

![Credit Card Popup](/resources/docs/myinedo-purchasingandrenewing-creditcard.png){height="" width="50%"}

Customers paying via credit card will instantly receive their license key and invoice after submitting payment. 

## Purchase Order
To pay via purchase order, simply fill out the required fields and upload a PDF version of your purchase order.

![Submit Purchase Order](/resources/docs/myinedo-purchasingandrenewinglicense-purchaseorder.png){height="" width="50%"}

After submitting a PO order, accounts receivable will verify your order and send an invoice along with all license keys to the provided email address within 2 business days. That invoice can then be paid using credit card, bank transfer, or check.

## Mail a Check
To pay via check, simply mail a check to the Remit To address. Make sure to include the Quote/Invoice Number so we can reconcile the payment.

## Bank Transfer
To pay via bank transfer, you will need to wire funds to our bank account. This form will add Wire/ACH Instructions to your invoice, and notify us that you intend to pay via bank transfer. Upon receipt of payment, we will update your selected invoice.

You can request Inedo's bank information by selecting "Pay via Bank Wire/Transfer" and providing an email. Our banking information will then be sent to that email account. 

## Inedo W9 and EULAs
[Our W9 form can be found here.](https://inedo.com/wp-content/uploads/2020/11/Inedo-W9-2019.pdf){target="_blank"}

EULAs are available on the relevant page for each product

* [BuildMaster](https://inedo.com/buildmaster/license-agreement){target="_blank"}
* [ProGet](https://inedo.com/proget/license-agreement){target="_blank"}
* [Otter](https://inedo.com/otter/license-agreement){target="_blank"}
