﻿---
title: "Web Hosting & HTTPS on Windows"
nav-title: "Web Hosting & HTTPS"
order: 5
---

Inedo products have a built-in web server that is often referred to as the *Integrated Web Server* in software and documentation. 

## About the Integrated Web Server

The Integrated Web Server (IWS) is based on [Kestrel](https://learn.microsoft.com/en-us/aspnet/core/fundamentals/servers/kestrel), a high-performance, cross-platform web server for .NET. Microsoft officially recommends Kestrel for modern .NET applications, and the IWS includes several important features:

* Operate in both HTTP and HTTPS modes on ports you desire
* HSTS, which will redirect HTTP requests to HTTPS
* Use Windows certificate store or disk-based files for HTTPS
* Specify a concurrent request limit to [help prevent server overload](https://blog.inedo.com/proget/how-to-prevent-server-overload-in-proget/){ target="_blank" }

The IWS also allows you to use port sharing on Windows and Integrated Windows Authentication.

## How to Configure HTTPS

HTTPS is effectively a requirement for modern web applications, even if you're only using it inside the firewall. It's relatively easy to use an SSL certificate with the IWS; see [Configuring HTTPS on Windows](/docs/installation/windows/web/https-support) to learn more.

## Using Windows IIS with Inedo Products { #iis }

Like with most web-based applications that run on Windows, using IIS to host Inedo products has gone from being a requirement to being no longer supported. If you're still using IIS to host an Inedo product, you will need to [switch to the Integrated Web Server](/docs/installation/windows/web/howto-switch-to-integrated-web-server-from-iis) to upgrade to the latest versions.

### 2025 Versions and Later { #iis-2025 }

It's no longer possible to use IIS to host the 2025 and later versions of our products. 

:::(Error)
🚫 IIS is No Longer Supported for 2025 Versions and Later
:::

However, it's possible [Configure IIS as a Reverse Proxy for the Integrated Web Server](/docs/installation/windows/web/howto-use-iis-as-reverse-proxy). This may be desired if you want to configure port sharing (i.e. binding to hostnames) in IIS or enable advanced HTTP/access logs.

### 2022 - 2024 Versions { #iis-2024 }

Following Microsoft's guidance to [no longer use IIS for modern .NET applications](https://learn.microsoft.com/en-us/aspnet/core/fundamentals/servers/kestrel), we stopped recommending IIS to host modern versions (2022+) of our products.  

:::(Warn)
⚠️ IIS is Not Recommended for 2022 - 2024 Versions
:::

While it's possible to host modern .NET applications in IIS, it's significantly more complex from a technical perspective, requiring server administrators to fine-tune hosting models and parameters - many of which were never designed for modern .NET applications.  In addition, settings from other web sites and applications hosting in IIS often interfere with settings defined in modern .NET  applications.

Note that hosting in IIS requires that a special [ASP.NET Hosting Bundle](https://learn.microsoft.com/en-us/aspnet/core/host-and-deploy/iis/hosting-bundle) be installed at the system level, which the Inedo Hub will attempt to do automatically.

### Older Versions (before 2022) { #iis-older }

Older versions of our products were built on .NET Framework. Microsoft generally recommended using IIS to host .NET Framework applications.

:::(Info)
👌 IIS is OK for Older Versions (before 2022)
:::

While the Integrated Web Server (IWS) is available in older versions, it wasn't as easy to configure and had limited configuration options (including HTTPS).

If you need to configure or maintain an older version of an Inedo product, you may find the following archived documentation helpful::
- [Hosting Through IIS Instead of the Integrated Web Server (archive.org)](https://web.archive.org/web/20231209233952/https://docs.inedo.com/docs/various-iis-switching-to-iis)
- [Configuring IIS Roles & Features for Inedo Products (github.com)](https://github.com/Inedo/inedo-docs/blob/44a99e458fe3ac2972ffa7e74b48de8fd342ed18/Content/installation/installing-on-iis/various-iis-configuring-iis-roles-and-features.md)
- [Disabling WebDAV in IIS (github.com)](https://github.com/Inedo/inedo-docs/blob/44a99e458fe3ac2972ffa7e74b48de8fd342ed18/Content/installation/installing-on-iis/various-iis-disabling-webdav.md)



