---
title: "Inedo SDK"
order: 8
icon-url: "/resources/docs/inedosdk-icon.svg"
---

A lot of Inedo's product functionality is delivered through extensions, a type of pluggable component library that provides both core capabilities as well as integrations with third-party tools. 

:::(Info) (👩‍💻 Creating Your Own Extension)
Using the  Inedo SDK, you can add similar integrations, functionality, and capabilities to the product by [creating your own extension](/docs/inedosdk/extending-inedo-tools-using-the-sdk/inedosdk-extending-creating). 
:::

Some of the components can be used different products, which means you can write a component once and introduce the same functionality across all of our products. 

## Common Components (ProGet + BuildMaster + Otter)


|                          |        |
| ------------------------ |--------|
|**[User Directory](https://sdkdocs.inedo.com/sdk/inedosdk/Inedo.Extensibility.UserDirectories/UserDirectory)**        | Responsible for authenticating users and groups. The default implementation uses users and groups stored in the product's database. |
|**[Variable Function](https://sdkdocs.inedo.com/sdk/inedosdk/Inedo.Extensibility.VariableFunctions/VariableFunction)**     | Used in OtterScript and WebHooks to provide or manipulate values. |


## Execution Engine Components (BuildMaster + Otter)
|                          |        |
| ------------------------ |--------|
|**[Configuration](https://sdkdocs.inedo.com/sdk/inedosdk/Inedo.Extensibility.Configurations/PersistedConfiguration)**         | A representation of a specific type of server configuration (such as the settings for an IIS Application Pool, or a directory on disk) that is used to store information collected from a server (Otter only) or as a template for desired configuration. |
|**[Operation](https://sdkdocs.inedo.com/sdk/inedosdk/Inedo.Extensibility.Operations/Operation)**             | A discrete task that is executed by the OtterScript runtime. |
|**[Raft Repository](https://sdkdocs.inedo.com/sdk/inedosdk/Inedo.Extensibility.RaftRepositories/RaftRepository2)**       | A self-contained abstract file system that is used as a backing store for plans, assets, and other files. |
|**[Secure Credential](https://sdkdocs.inedo.com/sdk/inedosdk/Inedo.Extensibility.Credentials/SecureCredentials)**     | A secret with secure fields that is stored in an encrypted manner. |
|**[Secure Resource](https://sdkdocs.inedo.com/sdk/inedosdk/Inedo.Extensibility.SecureResources/SecureResource)**       | A connection to a tool or service that may use a Secure Credential. |
|**[Variable Type](https://sdkdocs.inedo.com/sdk/inedosdk/Inedo.Extensibility.VariableTemplates/VariableTemplateType)**         | Allows for definition of an input variable used in Pipelines and Job Configuration Teyplates. |


## BuildMaster-Only Components
|                          |        |
| ------------------------ |--------|
|**Issue Tracker ([Service](https://sdkdocs.inedo.com/sdk/inedosdk/Inedo.Extensibility.IssueTrackers/IssueTrackerService) / [Project](https://sdkdocs.inedo.com/sdk/inedosdk/Inedo.Extensibility.IssueTrackers/IssueTrackerProject))**   | Provides information and utility methods for integrating with an issue tracker
|**Git ([Service](https://sdkdocs.inedo.com/sdk/inedosdk/Inedo.Extensibility.Git/GitService) / [Repository](https://sdkdocs.inedo.com/sdk/inedosdk/Inedo.Extensibility.Git/GitServiceRepository))**            | Provides information and utility methods for integrating with a git repository host
|**CI Server ([Service](https://sdkdocs.inedo.com/sdk/inedosdk/Inedo.Extensibility.CIServers/CIService) /  [Project](https://sdkdocs.inedo.com/sdk/inedosdk/Inedo.Extensibility.CIServers/CIProject))**             | Provides information and utility methods for integrating with a CI server
|**[Resource Monitor](https://sdkdocs.inedo.com/sdk/inedosdk/Inedo.Extensibility.ResourceMonitors/ResourceMonitor)**       | Used to montior a secure resource (source control, CI server) and trigger a script or build |
|**[Promotion Requirement](https://sdkdocs.inedo.com/sdk/inedosdk/Inedo.Extensibility.PromotionRequirements/PromotionRequirement)** | An automatic approval for a pipeline gate, to prevent builds from being deployed to a stage  |


## ProGet-Only Components
|                          |        |
| ------------------------ |--------|
|**[File System](https://sdkdocs.inedo.com/sdk/inedosdk/Inedo.Extensibility.FileSystems/FileSystem)**           | Used by ProGet to access the underlying storage medium for package data. The default implementation uses a directory on disk. |
