---
title: "Security and Access Controls"
order: 1
---

Security and access control policies are defined by granting principals (users or groups) permission to perform certain tasks in a specific area (either environment-specific, application-specific, application group-specific, or global). For example, you can create a policy like the following:

> The *HDARS Developers* group may *Deploy to Environment* to the *Development* environment.

Principals are defined in a user directory that is either internal (i.e. built into BuildMaster) or external (such as Active Directory and LDAP). This allows you to create a single sign-on experience while allowing other members of the organization to manage user accounts and group memberships.

You can also restrict principals from performing tasks, for example:

> The *Developers* group may not *Deploy to Environment* for the *Production* environment.

These overlapping rules, as well as externally defined user directories, can be used to model granular access control policies.

## Free Edition Restrictions

Permissions and task resolution are not available in the BuildMaster Free Edition. Refer to [Security in the Free Edition](/docs/buildmaster/administration/buildmaster-licensing) for more information. 

## Tasks

BuildMaster ships with five built-in tasks.

| Task | Description | 
|---|---|
| Administer | Allows unrestricted access to all functionality within BuildMaster. | 
| Coordinate Releases | Allows release planning (but not deployment) functionality for an application. | 
| Deploy to Environment | Allows environment-specific deployment functionality within the context of an application. | 
| Manage Application | Allows full managerial and deployment access within the context of an application. | 
| View Application | Allows view access within the context of an application. |

## Adding Permissions and Restrictions

Tasks are assigned to principals by adding or deleting grants (permissions and restrictions) from the _Admin > Security > Tasks_ page. Grants are comprised of the following:

*   Principal - either a user or a group
*   Scope - a specific environment, all environments, a specific application, an application group, or all applications
*   Task - what the principal may (or may not) perform

### Task Resolution

Because you can define both permissions and restrictions at multiple levels, determining whether a user is allowed to perform a particular action can be quite complex. In general, BuildMaster uses the following guidelines to resolve tasks:

1.  More specific grants override less specific
2.  Restrictions override Permissions

::: (info)
#### For example, consider the following set of rules:

1.  The 'Developers' group may 'Deploy to Environment'
2.  The 'Developers' group may _not_ 'Deploy to Environment' in a 'Production' environment
3.  The 'Developers' group may 'Deploy to Environment' in the 'HDARS' application in a 'Production' environment

A more natural way to describe this in English might be:

Developers are allowed to deploy builds to any environment except Production. Unless it's the HDARS application, in which case they *can* deploy them to production.
:::

In this case, the restriction (rule 2) only applies to the Production scope; and in that case, it will override the first grant (rule 1). However, the second grant (rule 3) is more specific than the restriction (rule 2), and thus is overridden.

### Specific Algorithm

All of the grants that would apply to the attribute demand (e.g., view application, deploy build) for the specified scope (e.g., application, environment) are gathered into a list and  sorted by comparing each rule's scope using the following priority.

 - User
 - Application + Environment
 - Application
 - Application in Ancestor Application Group
 - Environment
 - Environment Ancestor
 - Restriction

::: (info)
For example, a User-specific rule will be sorted above an Application rule. The first rule is used; if it is a grant, the user will be permitted to perform the requested action.
:::

## Users and Groups

A _user directory_ is a collection of users and groups that BuildMaster can query. They are extensible (meaning you can write your own), and BuildMaster ships with two directories:

 - Built-In - The default basic user account system used by new installs of BuildMaster.
 - LDAP/Single Domain - Users and groups from an LDAP directory (Active Directory) are used; this can come from multiple domains in an Active Directory forest.

::: (info)
Task permissions and restrictions are associated with a user directory, which means that "bob-smith" from the Built-in Directory will not necessarily have the same permissions as "bob-smith" from the Active Directory.
:::

Directories are exclusive; meaning you can only use one at a time. For this reason, it's important to make sure you will have sufficient administrator permissions in BuildMaster for the user directory you are switching to. If you do accidentally lock yourself out, don't worry; you can [reset the password](/docs/installation/security-ldap-active-directory/various-ldap-troubleshooting#locked-out).

### Built-In Directory

BuildMaster's built-in user directory is used by default and initially contains a user with the username Admin. You can add additional users and groups to this directory from the _Admin > Security > Users_ page.

### Active Directory LDAP

This is common to all our products; check out the [shared documentation](/docs/installation/security-ldap-active-directory/various-ldap-ldap-active-directory).

## Virtual Privilege Assignments

As of BuildMaster v6.1.8, privileges may be granted or restricted to the following catch-all principals in any user directory:

 - **Everyone** - all users with network access to the system, regardless if they are authenticated or not
 - **Authenticated** - all users who have supplied valid login credentials
 - **Anonymous** - all unauthenticated users with network access to the sytem (i.e., have not logged in)

## Hybrid User Directories

Starting with BuildMaster v6.1.8, a hybrid user directory can be used to combine multiple user directories by resolving principals from one or more existing user directories. This allows BuildMaster administrators to configure the system so that, for example, user accounts can be defined in BuildMaster with a fallback to Active Directory.

Visit the [Hybrid User Directories](/docs/installation/security-ldap-active-directory/legacyconfigurations/various-ldap-combining-with-built-in) documentation for more information.