---
title: "Package Promotion"
order: 3
---

<h1>What is Package Promotion and Why Should I Use It</h1>

Package Promotion is the process of promoting packages between feeds to ensure that only approved and verified packages are used in the right environments, such as production. 

In ProGet, packages can be promoted from one feed to another and tracked throughout the process. This allows you to build a promotion pipeline that allows you maintain separate levels of quality in different feeds (such as Development, Production, etc). It also enables you to easily curate selected packages from an external source to an approved repository.  

:::(Info) 
This feature is limited in ProGet Free. Compare [features by edition](/docs/proget/administration/license) or [request a quote](https://inedo.com/proget/pricing/request-quote).
:::


## How to Promote a Package 
There are two ways to promote a package, using the Promote Package button in the Package Version page in ProGet, or an API call. Any packages that are promoted to a target feed are __not__ deleted from the source feed.

### Creating a Validated/Promoted Package Feed 

Any feed can be used as a validated/promoted package feed, but it is recommended to create a separate feed containing only promoted internal packages and verified external packages. When creating your new feed, select the _validated/promoted_ feed usage type.

#### Promoting Packages Using The Package Version Page

To promote a package using the Package Version page, first navigate to the feed, package, and version you want to promote. Hover over the _▼ button_ in the upper right corner and click the _Promote Package_ button.

:::(Info) 
Package promotion via the package version page is limited in ProGet Free. If you use ProGet Free, you can promote packages, but only through this page, and you'll not be able to see who did it, when, or why.
:::


#### Promoting Packages Using API 

To promote a package via the API, you will first need to generate an API key that grants access to Package Promotion. Then visit our [Package Promotion Endpoint](/docs/proget/packages/package-promotion) guide in our [ProGet API Reference](/docs/proget/api) section to familiarize yourself on how to work with the ProGet APIs and the Promote Packages endpoint.

:::(Info)
Package promotion via the API is not availabile in ProGet Free.
:::


### Creating a Package Promotion Pipeline

A [package promotion pipeline](https://blog.inedo.com/nuget/nuget-package-approval-workflow/) helps you to enforce the process of promoting packages between your different feeds/environments by selecting a specific target feed. Once a target feed is selected to promote to, both the Package Version Page and the [Package Promotion Endpoint](/docs/proget/packages/package-promotion) will only allow you to promote packages to the selected target feed.

To configure the pipeline, you need to do the following:
1. Navigate to the source feed that contains the packages you want to promote 
2. Click the _Manage Feed_ button in the upper-right corner of the page 
3. Click the _configure_ link to the right of the _Promote To Feed_ property 
4. Select the target promotion feed

**Note:** A validated/promoted package feed can be a source feed for another validated/promoted package feed. This way you can keep environments in different feeds separate and enforce a promotion  process across all feeds.

## Package Promotion Security 

Promote Packages is a [built-in task](/docs/proget/administration-security) in ProGet. This task allows access to promote packages to a specified feed of the same feed type. Users granted this task should also be granted at least the View & Download Packages task for the source feed. 

You can also create a [Custom Task](/docs/proget/administration-security/creating-tasks) page by going to `Administration > Users & Tasks > Customize Tasks`. To give or deny users/groups permissions to this task go to the Users & Tasks page.

## Track Your Package Promotions

Package promotion tracking is viewable in the _History_ tab on the Package Version page.  The history will show a _Promoted_ action that includes:
- When the promotion occurred
- Who promoted the package
- The source feed
- The target feed
- Any comments left by the promoter

|Action|On|Detail
|-----|-----|------
Promoted|5/14/2020 1:30:15 PM by Admin|from devnuget to rcnuget<br/>Ready for testing
Promoted|5/15/2020 1:30:15 PM by API|from rcnuget to prodnuget<br/>Release 12.0.5