---
title: "Upgrading Otter"
order: 4
url-slug: "otter-upgrading"
---

Otter is self-managed, which means you can control when and how often to upgrade. When planning for an upgrade to your Otter instance, there are two categories of releases to consider:

* **Maintenance releases** low risk and contain only backward-compatible enhancements, bug fixes, and security patches; we we recommend upgrading to the latest maintenance release at least once per quarter
* **Major releases** typically implements a brand new feature or overhauls an existing one, and is inherently riskier than a maintenance release; we recommend carefully reading the release notes before planning upgrade

See [When should I upgrade my Inedo Product?](/docs/installation/upgrading#when-should-i-upgrade-my-inedo-product) and view our [Upgrade Guidance](/docs/installation/upgrading#viewing-upgrade-guidance) to learn more.

## Otter Upgrade Path
You can find which version of Otter you're currently using in the bottom-right corner of the Otter web application.

| Current Version | Upgrade Path |
| --- | --- 
| Otter&nbsp;2025.* | *This is the current release, and you should perform regular maintenance upgrades to stay up to date.*
| Otter 2024.\* <br /> Otter 2023.\* <br /> Otter 2022.\* <br /> Otter 3.\*.\* <br />Otter 2.\*.\* <br />Otter 1.\*.\* | Upgrade directly to latest Otter 2025 ([see notes](/docs/otter-upgrade-2025))

## How to Upgrade Otter

What method to use for upgrading Otter really depends on [how you installed Otter](/docs/otter/installation-upgrading/otter-installation-guide) in the first place. But before upgrading, we do recommend [performing a back-up](/docs/installation/backing-up-restoring), just in case something goes wrong and you need to rollback. This is especially important when performing a major upgrade.

### Windows Servers (Inedo Hub)
If you installed Otter on Windows using the [Inedo Hub](/docs/installation/windows/inedo-hub), it's a really easy process.

![Inedo Hub](/resources/docs/Inedo%20Hub%20Home%202.png)

Simply click "Upgrade" next to Otter, select the desired version, and click Install.

### Linux Servers (Docker)

If you installed Otter on Linux, you can follow our [upgrading your Docker containers guide](/docs/installation/linux/installation-upgrading-docker-containers) to learn more.
