---
title: "Universal Feed"
order: 11
---

Universal Feeds can be queried using Inedo's [pgutil](/docs/proget/api/pgutil) command line tool and the [Common Packages API](/docs/proget/api/packages). There is also a special Universal Feed API, which was developed before the Common Packages API. While the Universal Feed API is still functional, we recommend using the Common Packages API if a required endpoint is available.

## pgutil Commands

In addition to the endpoints found in the [Common Packages API](/docs/proget/api/packages), the [pgutil](/docs/proget/api/pgutil) CLI tool provides several commands to install and manage Universal packages.

* `upack create`: Creates a Universal Package at a specified location
* `upack install`: "Installs" (unpacks) a Universal Package to a specified location
* `upack list`: Lists all "installed" Universal Packages
* `upack update`: Updates a package installation with another version from a specified Universal Package feed
* `upack remove`: "Uninstalls" the specified Universal Package

You can read more about using these commands on the [Universal Feeds & Packages](/docs/proget/feeds/universal/universal-packages) page.

## Universal Feed Endpoints

These endpoints are part of the original Universal Feed API and offer additional functionality. The API consists of a few different URL endpoints, accessible over HTTP/S. All endpoints are prefixed with `/upack/«feed-name»`:

* [Import Universal Package](/docs/proget/api/universal-feed/import) - imports a package from specified source
* [Create/Upload Universal Package](/docs/proget/api/universal-feed/upload) - creates and/or uploads a specified package
* [Download Virtual Package](/docs/proget/api/universal-feed/download-vpack) - downloads a specified virtual package
* [Download Universal Package File](/docs/proget/api/universal-feed/download-file) - downloads a specified file within a package

Note that the endpoint prefix itself is not a valid API endpoint, and may return a `404` error, or simply redirect you to this page.

Currently, the API only returns results in JSON format with a standard, `200` (success) status code unless there's an error; future versions (if anyone requests it) may add additional formats, such as XML, which would be specified using a `Content-Type` request headers and/or an alternate querystring parameter.

All searching and matching is case insensitive. This will most certainly never change, as it's either a mistake or a bad practice to have different packages named `SomeThing` and `someThing`.

### Legacy Universal Feed Endpoints:

The following endpoints are duplicative of the [Common Packages API](/docs/proget/api/packages) endpoints and should be avoided when possible:

* [List Universal Packages](https://github.com/Inedo/inedo-docs/blob/6dc089e74c549fdc1f5f880afcdce565a5f5ab24/Content/proget/api/universal-feed/list.md) - lists specified packages
* [List Universal Package Versions](https://github.com/Inedo/inedo-docs/blob/6dc089e74c549fdc1f5f880afcdce565a5f5ab24/Content/proget/api/universal-feed/version.md) - describes versions of specified packages
* [Delete Universal Package](https://github.com/Inedo/inedo-docs/blob/6dc089e74c549fdc1f5f880afcdce565a5f5ab24/Content/proget/api/universal-feed/delete.md) - deletes a specified package
* [Download Universal Package](https://github.com/Inedo/inedo-docs/blob/6dc089e74c549fdc1f5f880afcdce565a5f5ab24/Content/proget/api/universal-feed/download.md) - downloads a specified package

While we don't plan on removing them in the foreseeable future, they are considered legacy. Once the Common Packages API includes metadata queries, we will likely call these endpoints "deprecated".

The **Data Objects** for the `List Universal Packages` and `List Universal Package Versions` endpoints can also be found on the [deprecated documentation](https://github.com/Inedo/inedo-docs/blob/6dc089e74c549fdc1f5f880afcdce565a5f5ab24/Content/proget/api/universal-feed/%23.md)


## Authenticating to API Endpoints { #authentication }

The following is a summary of access types and their corresponding requirements for various API keys types and endpoints within this API.

| Access Type | Requirements |
| --- | --- |
| System API Keys | `Use/Manage Feeds`  
| Feed API Keys | `View/Download` is required for all endpoints<br/>`Add/Repackage` is required for uploading/importing endpoints<br/>`Overwrite/Delete` is required for deletion endpoints
| Personal API Key | `Feeds_ViewFeed` is required for all endpoints<br/>`Feeds_AddPackage` is required for uploading/importing endpoints<br/>`Feeds_DeletePackage` is required for deletion endpoints
| No API Key | anonymous or authenticated user must have at least `Feeds_ViewFeed`

To specify an API Key, use the request header (`X-ApiKey`), querystring (`key`), or `api:«api-key»` as the username. See [API Key Usage](/docs/proget/api/apikeys#using-api-keys) to learn more.

:::(Info) (🚀 Quick Example: Authenticating with curl)
For example, to authenticate with the API key `abc12345` to the "Import Universal Package" endpoint, you could specify the API key as follows:
````
curl -X GET --header "X-ApiKey: abc12345" "https://proget.corp.local/upack/MyUniversalFeed/import"
````
:::
