---
title: "Permission Updates in BuildMaster 5.0"
order: 1
---

<section class="warningBox"><div class="title">Outdated Content (BuildMaster v5)</div><div class="content"><p class="info">This document only applies to users upgrading from BuildMaster v5 and is a companion to <a href="/docs/buildmaster/installation-maintenance/buildmaster-upgrading/upgrading-from-buildmaster-v5" rel="nofollow" translate="no">Upgrading from BuildMaster v5</a>.</p></div></section><p>Permissions in BuildMaster v5.0 are simpler than in previous versions, but in most cases the granularity is the same. Previous versions had up to 66 "tasks", many of which were either merged (Builds_ViewExecutionDetails &amp; Builds_ViewPromotionDetails) or simply nonsensical (Admin_ManageExtensions without Admin_ControlService). In this version there are only 27 individually securable permissions.</p><div id="role-migration"><h3>Role Migration</h3><p>As part of the UX overhaul, "Roles" have been renamed to "Tasks", and the names of the roles have been updated to sound more task-like.</p><table><thead><tr><th>Default Roles (Old)</th><th>Default Tasks (5.0)</th></tr></thead><tbody><tr><td>BuildMaster</td><td>Administer</td></tr><tr><td>Administrator</td><td>Administer</td></tr><tr><td>Developer</td><td>Deploy to Environment</td></tr><tr><td>View Only</td><td>View Application</td></tr><tr><td>QA Analyst</td><td><em>removed</em></td></tr><tr><td>-</td><td>Coordinate Releases</td></tr></tbody></table><p>If you changed any of the default roles but did not rename them, they will be renamed to the new task names. Also, the role's customizable permissions (formerly "tasks") are reset to the new default definitions.</p><p>If you do not want this to happen during the upgrade, simply rename your role to something other than the default role or task name.</p></div><div id="extensions-tasks"><h3>Custom Extensions</h3><p>Though it is rare, custom extensions referencing the <code><a href="https://sdkdocs.inedo.com/sdk/buildmaster/inedo.buildmaster.web.security/securedtask">SecuredTask</a></code> enumeration must be modified and rebuilt to reference a new task. Consult the full list below to see which new tasks may be appropriate for your use case.</p></div><div id="task-conversions"><h3>Full Task Conversion List</h3><p>Former roles that contained the tasks on the left will automatically be updated to include the new tasks on the right.</p><table id="tasks"><thead><tr><th>Former Task</th><th>New Task</th></tr></thead><tbody><tr><td>Admin_AdministrativeEdits</td><td>Admin_ConfigureBuildMaster</td></tr><tr><td>Admin_Configure</td><td>Admin_ConfigureBuildMaster</td></tr><tr><td>Admin_ControlService</td><td>Admin_ConfigureBuildMaster</td></tr><tr><td>Admin_ManageExtensions</td><td>Admin_ConfigureBuildMaster</td></tr><tr><td>Admin_ManageLicense</td><td>Admin_ConfigureBuildMaster</td></tr><tr><td>Admin_ManageSecurity</td><td>Admin_ConfigureBuildMaster</td></tr><tr><td>Admin_ViewBuildMasterEvents</td><td>Admin_ConfigureBuildMaster</td></tr><tr><td>Applications_CreateApplication</td><td>Admin_ManageApplications</td></tr><tr><td>Applications_EditApplication</td><td>Applications_Manage</td></tr><tr><td>Applications_EditDeployable</td><td>Applications_Manage</td></tr><tr><td>Applications_PurgeApplication</td><td>Admin_ManageApplications</td></tr><tr><td>Applications_ViewOverview</td><td>Applications_View</td></tr><tr><td>Builds_CreateBuild</td><td>ReleasePackages_Create</td></tr><tr><td>Builds_ExecuteBuild</td><td>ReleasePackages_Deploy</td></tr><tr><td>Builds_ForceBuild</td><td>ReleasePackages_Force</td></tr><tr><td>Builds_ManageBuildSchedules</td><td>Applications_Manage</td></tr><tr><td>Builds_OverridePromotionStatus</td><td>ReleasePackages_Force</td></tr><tr><td>Builds_PromoteBuild</td><td>ReleasePackages_Deploy</td></tr><tr><td>Builds_ReExecuteBuild</td><td>ReleasePackages_Deploy</td></tr><tr><td>Builds_RejectBuild</td><td>ReleasePackages_Manage</td></tr><tr><td>Builds_ViewArtifact</td><td>Applications_View</td></tr><tr><td>Builds_ViewBuildHistory</td><td>Applications_View</td></tr><tr><td>Builds_ViewBuildOverview</td><td>Applications_View</td></tr><tr><td>Builds_ViewDebugLogs</td><td>ReleasePackages_ViewDeploymentDebugLogs</td></tr><tr><td>Builds_ViewExecutionDetails</td><td>ReleasePackages_ViewDeploymentLogs</td></tr><tr><td>Builds_ViewPromotionDetails</td><td>ReleasePackages_ViewDeploymentLogs</td></tr><tr><td>ChangeControls_ManageChangeControls</td><td>ChangeControls_Manage</td></tr><tr><td>ChangeControls_PerformAnyChangeControls</td><td>ChangeControls_Manage</td></tr><tr><td>ChangeControls_ViewChangeControls</td><td>Applications_View</td></tr><tr><td>ConfigurationFiles_DeployConfigurationFiles</td><td>ConfigurationFiles_Deploy</td></tr><tr><td>ConfigurationFiles_EditConfigurationFile</td><td>ConfigurationFiles_EditInstance</td></tr><tr><td>ConfigurationFiles_ManageConfigurationFiles</td><td>Applications_Manage</td></tr><tr><td>ConfigurationFiles_ViewConfigurationFile</td><td>ConfigurationFiles_ViewInstance</td></tr><tr><td>DatabaseChangeScripts_DeployChangeScript</td><td>SqlScripts_Deploy</td></tr><tr><td>DatabaseChangeScripts_ManageChangeScripts</td><td>SqlScripts_Manage</td></tr><tr><td>DatabaseChangeScripts_ManageDatabaseProviders</td><td>Applications_Manage</td></tr><tr><td>DatabaseChangeScripts_ViewChangeScript</td><td>SqlScripts_ViewContents</td></tr><tr><td>DatabaseChangeScripts_ViewDatabaseProvider</td><td>Applications_Manage</td></tr><tr><td>Environments_ManageEnvironments</td><td>Environments_Manage</td></tr><tr><td>Environments_ManageServers</td><td>Environments_Manage</td></tr><tr><td>Environments_ViewEnvironment</td><td>Environments_View</td></tr><tr><td>Environments_ViewServer</td><td>Environments_View</td></tr><tr><td>Events_ManageAllNotifiers</td><td>Admin_ConfigureBuildMaster</td></tr><tr><td>Events_ManageOwnNotifiers</td><td><em>removed</em>*</td></tr><tr><td>Issues_CloseIssue</td><td>Issues_Manage</td></tr><tr><td>Issues_CreateIssue</td><td>Issues_Manage</td></tr><tr><td>Issues_DeleteIssue</td><td>Issues_Manage</td></tr><tr><td>Issues_EditIssue</td><td>Issues_Manage</td></tr><tr><td>Issues_SyncIssues</td><td>Issues_Manage</td></tr><tr><td>Issues_ViewIssue</td><td>Applications_View</td></tr><tr><td>Plans_ManageGlobalPlans</td><td>Plans_Manage</td></tr><tr><td>Plans_ManagePlans</td><td>Plans_Manage</td></tr><tr><td>Plans_ViewActionDetails</td><td>Plans_Manage</td></tr><tr><td>Plans_ViewGlobalPlans</td><td>Plans_ViewContents</td></tr><tr><td>Plans_ViewPlan</td><td>Plans_ViewContents</td></tr><tr><td>Providers_DeleteProvider</td><td>Admin_ConfigureBuildMaster</td></tr><tr><td>Providers_ManageProviders</td><td>Admin_ConfigureBuildMaster</td></tr><tr><td>Releases_AddNote</td><td>Notes_Manage</td></tr><tr><td>Releases_DeleteNote</td><td>Notes_Manage</td></tr><tr><td>Releases_EditNote</td><td>Notes_Manage</td></tr><tr><td>Releases_ManageReleases</td><td>Releases_Manage</td></tr><tr><td>Releases_ViewReleaseOverview</td><td>Applications_View</td></tr><tr><td>Scripts_ManageScripts</td><td>ScriptAssets_Manage</td></tr><tr><td>Scripts_ViewScripts</td><td>ScriptAssets_ViewContents</td></tr><tr><td>Variables_CreateOrUpdateVariables</td><td><em>removed</em>*</td></tr><tr><td>Workflows_ManageWorkflows</td><td>Pipelines_Manage</td></tr></tbody></table><p>* 2 tasks were removed altogether:</p><ul><li><code>Events_ManageOwnNotifiers</code> - all users should be able to manage their own notifications</li><li><code>Variables_CreateOrUpdateVariables</code> - variables should be controlled by privileges depending on the scope of the variable, i.e., Release variables with <code>Releases_Manage</code> and Application-level variables with <code>Applications_Manage</code></li></ul></div>
