---
title: "User Directories & Domains (LDAP)"
order: 5
---

Inedo products come with built-in users and groups, but it can also integrate with an external directory service like [Active Directory](#active-directoryldap) or [OpenLDAP/Generic LDAP](#openldapgeneric-ldap). This allows you to use the organization's existing users, logins, and groups to secure the product and define the tasks users are permitted to do. 

:::(Warning) (Can't Log-in and Locked Out?)
If you ever get "locked out" of an Inedo product, either due to misconfiguration or a lost password, see [Locked out: Restoring Default Admin Account](/docs/installation/security-ldap-active-directory/various-ldap-troubleshooting#locked-out) to restore the default `Admin`/`Admin` account and reenable Built-in User Sign-on. 
:::

## Built-in Users & Groups

The built-in users and groups are rudimentary and not intended for most production environments. Although passwords are cryptographically hashed/salted (see [OWASP's Password Storage Guidelines](https://cheatsheetseries.owasp.org/cheatsheets/Password_Storage_Cheat_Sheet.html#hashing-vs-encryption)), it's "yet another account" for users to remember. In addition, built-in users lack advanced features like password complexity rules, automatic lockout, two-factor authentication, etc. 

When you first install an Inedo product, a built-in administrator account (`Admin`/`Admin`) will be created and you'll also be constantly prompted to change this password. You can also disable Built-in User Sign-on completely, which means users will only be able to log-in using their external (i.e. Active Directory/LDAP) credentials.

## Active Directory

The Active Directory (v5) user directory is a rewrite of Active Directory/LDAP (v4) that only supports Microsoft Active Directory and other LDAP servers that follow Active Directory Conventions.  For other LDAP servers that do not follow these conventions, please use the [OpenLDAP/Generic LDAP](#openldapgeneric-ldap) user directory.  You can add Active Directory (v5) by going to "Settings" > "Manage Security" > "Domains/User Directories" and clicking "Add User Directory".  Then select "V5: Active Directory" from the list.

::: (Info) (Note:)
Active Directory (v5) only available in ProGet 2024+, BuildMaster 2024+, and Otter 2024+ with InedoCore 3.0.5+ installed.  By default, Active Directory/LDAP (v4) is added by default.  
:::

For most servers joined to a domain no configuration is required. For non-domain servers, multi-domain forests, and other complex environments, you'll need to change or create additional User Directories; see [Active Directory (v5)](/docs/installation/security-ldap-active-directory/various-activedirectory-v5-advanced) to learn more.

## OpenLDAP/Generic LDAP

*This user directory only exists in ProGet 2024+, BuildMaster 2024+, and Otter 2024+ with InedoCore 3.0.4+ installed.*

The OpenLDAP/Generic LDAP User Directory was designed for OpenLDAP and other "pure LDAP" servers. 

It contains simplified/configurable LDAP queries and is bound to a single directory, but does not include Active Directory features like domain scanning. See [OpenLDAP/Generic LDAP](/docs/installation/security-ldap-active-directory/various-ldap-openldap) to learn more.

## Configuring Multiple Directories / Domains

You can configure as many user directories as you need and enable the directories you want to search. If there are multiple enabled user directories, they will all be used to search for users/groups and verify logins.

For example, if `mycompany.corp` and `trusteddomain.corp` are both configured, and the Built-in User Sign-on is Enabled:

 * If you enter `jdoe` in a search box then you may see:
   * `jdoechestor` (from the Built-in Users)
   * `jdoeson@mycompany.corp`
   * `jdoe@trusteddomain.corp`
   * `jdoedawn@trusteddomain.corp`
 
 * When a user logs in with `jdoe` and `hunter42`
   * the Built-in Users will be used to validate the login, and if that fails...
   * the `mycompany.corp` domain will be used, but if that fails...
   * the `trusteddomain.corp` domain will be used
   * the user will get an "invalid login" error if they all fail

As a result, this behavior may yield to logging of failed logins. The exception to behavior is if the username contains a `@` or `\` symbol, such as `jdoe@mycompany.corp` or `COMPAN\jdoe`. In that case, only the domains that matching that name searched.

## Importing and Exporting Security Configuration
You can import or export users/groups and tasks/permissions as JSON documents. This can be useful for diagnostic purposes, bulk editing or migration of instances.

* To import or export users/groups, navigate to Admin > Manage Security > Built-In Users & Groups and then select either "Export Users & Groups" or "Import Users & Groups".

* For Tasks/Access Rights, navigate to Admin > Manage Security > Tasks/Access Rights, and then select either "Export Tasks" or "Import Tasks".

This feature is available from ProGet 2022, BuildMaster 2022 and Otter 2022.

## Testing User Directories
Testing your configured user directories can be useful when you have advanced configurations or are encountering LDAP connection issues. When using an advanced configuration, it is best practice to test your user directory prior enabling it.

To test your user directories, follow these steps:

1. Go to Administration > Manage Security.
2. Click "Test User Directories" in the upper right corner.
3. Select either "All Active User Directories" (tests all enabled user directories) or the specific user directory (enabled or disabled) that you want to test.

The test options are:
- Test Login: Tests logging in as a specific user.
- Load User by User Name: Loads a user by their username and, optionally, tests if they are a member of a specific group.
- Load Group by Group Name: Loads a group by name.
- Search for Users: Searches for users starting with the entered text.
- Search for Groups: Searches for groups starting with the entered text.

The results of the tests and a debug output from the query will be displayed after running the tests.

