---
title: "Creating/Accessing your MyInedo Account"
order: 2
---

MyInedo is your self-service portal for all your Inedo products. A MyInedo account is necessary to check expiring licenses, create quotes, purchase licenses, open support tickets, etc. 

## Creating a MyInedo Account
To create a MyInedo account simply go to [my.inedo.com](https://my.inedo.com/){target="_blank"} and register an email address under "Create Account / Retrieve Password." After entering your name, company, and password you'll be brought to your MyInedo portal.

![Enter email under create account](/resources/docs/myinedo-myinedoaccount-createaccount.png){height="" width="50%"}

## Joining an Existing MyInedo Account
If your organization already has an account or is using one of our products, you can automatically join that organization. In order to join an existing organization, you first have to create your own account, then click on "Join Organization".

![Click join organization](/resources/docs/myinedo-myinedoaccount-joinorganization.png){height="" width="50%"}

You will then be prompted to enter a License Key associated with the organization. These license keys are visible to any currently registered members within your organization. If the key matches a registered organization, you will be given the option to join the organization.

If the organization is correct, click "Join Organization".

![Enter organization license key](/resources/docs/myinedo-myinedoaccount-joinorganizationlicensekey.png){height="" width="50%"}

Your MyInedo page will now display all keys associated with your organization, as well as a list of invoices and outstanding quotes. 

## Organization & Roles
Roles allow organizations to delegate different permissions and responsibilities. To find organization information including account number, organization name, address, members, and roles click on "Your Organization" on the MyInedo home page. 

From here you can edit all your organizations information, add or remove members, and delegate roles. 

![Organization Members List](/resources/docs/myinedo-accounts-organizationdetails.png){height="" width="50%"}

To edit a member's role, click the pencil icon at the end of their row. 

![Edit Organization Member](/resources/docs/myinedo-accounts-editmember.png){height="" width="50%"}

* **MyInedo Account Administrator:** This account has the ability to add new members, edit existing members, assign a renewal contact, and delete current members. If no other member is assigned as a renewal contact, the Account Admin will be contacted. 
* **Contact for renewal when license/support will expire:** This account will be the point-of-contact for license/support renewal. All reminders and license keys will be sent through this contact. Resellers should be selected as the contact for renewal. 
