---
title: "Otter API Reference"
order: 2
---

[Otter](/docs/otter/overview) helps you automate configuration and installation of *other* software on your servers. To help you automate and configure Otter, there are various API endpoints you can use to programmatically query or configure Otter instances.

In general, you should avoid the Native API when possible. The other endpoints are much simpler to use, better documented, and will almost always be backward- and forward-compatible


- **[Job Orchestration](/docs/otter/reference/api/jobs)** - trigger and check the status of orchestration jobs
- **[Configuration Management](/docs/otter/reference/api/configuration-management)** - check the status of server, role, and environment configuration, as well as remediate drift
- **[Infrastructure Management](/docs/otter/reference/api/infrastructure)** - query, create, and update [server](/docs/otter/connecting-to-your-servers-with-otter/otter-servers-in-otter), [environment](/docs/otter/connecting-to-your-servers-with-otter/otter-modeling-infrastructure-environments), and
[server role](/docs/otter/connecting-to-your-servers-with-otter/otter-modeling-infrastructure-server-roles) entries; they are intended to automate the set-up and management of an Otter instance.
- **[Variables Management](/docs/otter/reference/api/variables)** - view, create, update, and delete [configuration variables](/docs/otter/reference/api/variables#endpoint-specification)
- **Native API Methods** - callable through JSON, SOAP, or even SQL directly, these offer full control of an Otter instance and can be used to do anything that a user may do from the web interface; these may change between minor versions (which are always documented in the release notes), but are often backwards-compatible.

## Native API Reference 

These methods are callable through JSON, SOAP, or SQL. Note that the Native API must be explicitly enabled by setting an API key under Administration > All Settings. Because this is a low-level API, specific user or task authorization is not performed, and if needed, may be done through the various Security_ methods.

You can view the native API methods in Otter through `/reference/api`.