---
title: "API Keys & Access"
order: 3
---

An API key is used to grant access to ProGet's APIs, and allows scripts, tools, and other integrations to automate and interact with feeds and help manage ProGet.

## Creating and Managing API Keys

To create or manage API keys, go to `Administration` > `API Keys`. You will be presented with a list of API keys and the ability to edit, delete, and create new ones.

:::(Info) (🔌 Advanced Usage: CLI & HTTP API)
You can also use `pgutil` and HTTP endpoints to manage API Keys in ProGet. See [Create ApiKey](/docs/proget/reference-api/proget-apikeys/proget-api-apikeys-create), [List ApiKeys](/docs/proget/reference-api/proget-apikeys/proget-api-apikeys-list), and [Delete ApiKey](/docs/proget/reference-api/proget-apikeys/proget-api-apikeys-delete) to learn more.
:::

When creating or editing an API key, you'll first need to select the type of API Key:

* **System API Keys** let you automate the ProGet configuration and access packages, containers, and assets 
* **Feed API Keys** can be restricted to a single feed or group and provide only limited access to packages, containers, and assets
* **Personal API Keys** effectively "impersonate" that user's access to ProGet and can also be managed by ProGet end-users

The API key type is used to control what the API key can do in ProGet:

* **System API Keys** can either have Full Control (which grants access to everything) or be limited to Use/Manage Feeds, Manage SCA (Projects & Builds), and/or Upload SBOM documents.
* **Feed API Keys** can be limited to View/Download, Add/Repackage, Promote, and Overwrite/Delete in a particular feed or feed group.
* **Personal API Keys** use the associated user's privileges to determine what the key can do. These are based on [security task attributes](/docs/proget/administration-security/creating-tasks), and are scoped in the same manner.

You can change an API Key type or permissions at any time.

### API Key Display Name & Description

Display Name is an optional field that's used when showing API Keys in a list. When the display name is not specified, you'll see `(ID=2)` instead. The Description is also displayed in lists, and can be used for a more detailed explanation of how the key is used, and where.

### API Key Logging
By default, only minimal information about each request to and response from an API is logged. To aid in diagnostic purposes, you can change the logging level to include the request body, the response body or both.  Note that, if you have a lot of large requests, there will be a nontrivial overhead and amount of database space required.  

You can review the API access logs by clicking the _Access Logs_ tab or by clicking the _logs_ link to the right of the key.

## "Pseudo-key" API Keys (i.e. user:password)

In place of an API Key, ProGet allows users to specify a "pseudo-key" that's comprised of a `«username»:«password»`. For one-off tasks or manually-run scripts, it might be bothersome to create and configure API Keys, which is why these are allowed by default.

:::(Warning)
`username:password` keys are not appropriate for use in automation like CI/CD pipelines; they're fine for one-off or debugging purposes.
:::

These pseudo keys work like a Personal API key, in that you will have the same access to ProGet's APIs as you would otherwise. Requests are not logged, however.

Pseud-key API Keys can be disabled by Configuring API Access.

## Using API Keys 

API Keys are used by `pgutil` and HTTP Endpoints, and by third-party clients like Visual Studio, npm, etc.

### pgutil Commands
An API key can be specified as an option (`--key`) or associated with a source so that you don't have to enter it every time.

See [Getting Started with pgutil](/docs/proget/reference-api/proget-pgutil) to learn more.

### HTTP Endpoints
An API key should be passed to an HTTP Endpoint in the `X-ApiKey` HTTP header. For example:

```
curl --header "X-ApiKey: 70f875c2593ef93d0b21400d5f94ea1d8ed519d0" https://proget.corp.local/api/promotions/list?package=Newtonsoft.Json&version=13.0.2
```

You can also specify the API key via the `key` Querystring value or a Form or JSON property, depending on the content type. See [Getting Started with HTTP Endpoints](/docs/proget/reference-api/proget-api-http) to learn more.

### Feeds API & Other Clients

Different feed types (NuGet, npm, etc.) have different APIs. Many of the clients (Visual Studio, npm, etc.) support using an API key to authenticate some operations like publishing packages.

When the client supports an API key, you just use an API Key you created in ProGet. For example:

```
dotnet nuget push MyNuGetPackage.nupkg 
  --api-key 70f875c2593ef93d0b21400d5f94ea1d8ed519d0 
  --source https://proget.corp.local/nuget/MyNuGetFeed
```

However, many will *not* support using an API Key for listing or downloading packages. Instead, you'll need to authenticate using Basic (Username/Password) authentication. 

When the client prompts for Username/Password, you can use `api` for the USername, and an API Key you created in ProGet. For example:

```
 pip install MyPyPiPackage
   -i https://api:70f875c2593ef93d0b21400d5f94ea1d8ed519d0@proget.corp.local/pypi/MyPythonFeed 
```

However, each client is configured a little differently, so see the feed-specific documentation (e.g. [NuGet Feeds](/docs/proget/feeds/nuget#nuget), [npm Feeds](/docs/proget/feeds/npm#token), etc.) to learn more.

## Configuring API Access & Key Storage
ProGet allows for less-than-ideal configuration for API key security to help provide a balance of security and flexibility.

:::(Warning)
Several of these options are considered insecure, especially for large organizations.
:::

### Cryptographic Hashing vs Plain Text Storage
When cryptographic hashing is disabled, keys will be stored as plain text instead of hashes. Although this means you'll be able to see the key in PrGet, this does increase unauthorized access vectors

### Pseudo-keys Permitted vs Allowed
Pseudo-keys allow for `«username»:«password»` authentication. Although this is simpler than creating a key, it does lead to passwords being insecurely stored in scripts.

### Expiring vs Non-expiring keys

Expiring keys can be a hassle, but non-expiring keys increase the window of opportunity for unauthorized access and exploitation

### Personal API Keys Enabled vs Disabled
Personal API Keys allow end-user to create their own API Keys. While this may lead to a lot more keys, it does make it much easier to provide users with secure, key-based means of access.

###  Generated vs Custom (User-entered) API Keys

By default, ProGet will auto-generate a secure API Key. This is an arbitrary string that acts like a password, and should be treated like one. 

However, to help you migrate from other instances or tools, you can enter any value you'd like for the API Key text. This also means users can enter any text they'd like as an API key, including short and easily-guessable strings.



## ProGet 2023 and Earlier

In ProGet 2023 and earlier, API Access & Key Storage, Expiration, and Last Use are not available. You also can't programmatically create API Keys.

### Other/legacy Keys
In ProGet 5.3 and earlier, API Keys did not have a type nor the same permissions. If you see an "Other" key listed as the type, it was likely created in ProGet 5.3 or earlier. See [API Access and API Keys  (archive.org)](https://web.archive.org/web/20231210162915/https://docs.inedo.com/docs/proget-administration-security-api-keys#other-legacy-keys) to learn more.