---
title: "パッケージとは"
order: 1
hidden: true
---

ProGet のドキュメンテーションをご覧くださりありがとございます。このページでは、ProGet におけるパッケージとは何か、マニフェストファイルとは、NuGet などのパッケージマネジャーと、ProGet 統合パッケージマネジャーとの違いについて説明します。

## パッケージとは

**パッケージ**とは、配布したいファイルと、パッケージの中身などを説明するマニフェストファイルが入ったZIPファイルです。パッケージファイルの拡張子とマニフェストファイルの書き方などは、パッケージのフォーマットによって異なります。

**マニフェストファイル**とは、アプリを展開、表示、または更新するために必要とする情報を含むドキュメントファイルです。この情報には、パッケージ ID、パッケージの依存関係、開発者などの情報が含まれています。パッケージやマニフェストファイルの形式はパッケージ管理システムにより異なります。例えば、NuGet は、マニフェストを XML で書き、**.nupkg** という拡張子の ZIP ファイルを使用します。

### パッケージとアーティファクトの違い
ソフトウェア開発における、アーティファクトとは「ソフトウェアを作る過程で生み出されたもの」を指します。広義では、あらゆるタイプのファイル (例えば、.jar、.war、.dll、.rpm、.zip、.jpg) がアーティファクトになります。企業によっては、ビルドした結果のバイナリファイルをアーティファクトと呼んだりしますが、アーティファクトは単なるファイルであり、マニフェスト データは含まれていません。

一方で、パッケージは定義されたフォーマット(例: NuGet、PyPi など)を持ち、ファイルだけでなくメタデータ（マニフェスト）も含まれています。

アーティファクトの多くはバイナリファイルなので、人間には読むには適していません。そのため、ビルドした人の名前、ビルドしたサービスの名前、リリースバージョン、ビルド実行時刻、ビルド実行環境、依存関係などを、マニフェストファイルとして記録して、パッケージとしてひとまとめにします。リリース時にある環境から別の環境へ移したり、エンジニア間でシェアする際に、マニフェストファイルが役に立ちます。

なお、複数のパッケージフォーマットを利用している場合、マニフェストファイルのフォーマットも作成方法も異なるため、パッケージの作業がより複雑になります。そこで、あらゆるフォーマットのパッケージを一元的に管理できるProGetのような統合パッケージマネジャーが役立ちます。

### パッケージマネジャーとは

**NuGet**、**PyPl**、**RPM**、**Helm**、**RubyGem**、**Maven**、**npm**、**Chocolatey** などのパッケージ管理システムを使えば、パッケージの中にある「マニフェストファイル」に書かれた、バージョン情報、作成者、パッケージ名、依存するパッケージなどを管理できます。

ProGet でパッケージ化したファイルのマニフェストファイルには、パッケージ名、バージョン情報、依存関係の他に、だれが、いつ、何をしたかなど、情報が含まれます。これにより、監査とロールバックが簡単になります。

また、パッケージでは以下のことも可能です。

* パッケージがテストされたことを示すために再パッケージ化
* 開発、テスト、配布など、パイプラインでの管理
* パッケージフィードへのアクセス権限の管理
* 脆弱性やライセンスの自動検知とブロック

:::(Info)
パッケージは原則として不変です。公開されたパッケージは変更不可能です。そのため、パッケージはビルドされたら、環境間で一貫してデプロイされるため、テストされたパッケージだけが確実に本番環境で使用されます。
:::
## ProGet と他のパッケージマネジャーの違い

### プライベート・セルフマネージド型

ProGet はセルフマネージド型のパッケージリポジトリ（サーバ）です。自社サーバにインストールして、自社のパッケージを非公開で利用できます。
また、nuget.server のような、最低限のソリューションとは異なり、ProGet は無料版でも、1つのインスタンスで何百ものパッケージをサポートできます。ProGet は、オープンソースパッケージのキャッシュコピーや、自社開発のパッケージなど、あらゆるパッケージをサポートします。

### パッケージの保管以外に操作が可能。
ProGet は、パッケージを保管するだけでなく、パッケージとリポジトリにたいして以下の操作ができます。

* レプリケーション
* リテンション
* コネクタ
* 脆弱性のスキャン
* ライセンス検出
* クラウドストレージ
など

### ProGet で使えるパッケージの種類
通常のパッケージマネジャーは、一種類のパッケージがサポートできません。例えば、nuget.server なら NuGet パッケージ nupkg という 拡張子の ZIP ファイルしか扱えません。一方で、ProGet は、複数のパッケージタイプをサポートしています。 

* NuGet
* PowerShell
* Ruby Gems
* Visual Studio拡張機能（.vsix）
* Maven（Java）
* npm（Node.js）
* Chocolatey（Windows / Machine）
* Debian（apt）
* Helm（Kubernetes）
* PyPi（Python）
* RPM（yum）
* Docker（コンテナー）
:::(Internal) (Link them)
:::

## ProGet のパッケージ保存場所？
ProGet のパッケージは、ProGet をインストールしたマシンに保存されます。また、nuget.server とは異なり、ProGetは、無料バージョンであっても、ひとつのインスタンスで何百ものパッケージをサポートできます。
また、nuget.org のようなパブリックパッケージリポジトリとは異なり、自社で開発したパッケージと、サードパーティのオープンソースパッケージの両方を管理、自社サーバにキャッシュを保存できます。

## サードパーティ/オープンソースパッケージの使用

現代の開発現場では、すべてを社内で開発することはほとんどありません。NuGet や Chocolatey などのサードパーティ/オープンソースパッケージを利用して開発するのが一般的です。

これらのパッケージを ProGet で使用するには、まずパッケージのタイプを選びます。次に、ProGetのフィードにコネクタを追加して、ProGet をパブリックリポジトリの URL （https://api.nuget.org/v3/index.json など）を入力します。
![ProGet-Feed-New](/resources/docs/ProGet-Feed-New.png){height="" width=""}

![ProGet-Create-Connector](/resources/docs/ProGet-Create-Connector.png){height="" width=""}

サードパーティのパッケージをローカルにキャッシュすることで、パッケージのダウンロードにかかる時間を短縮できます。また、パッケージやマニフェストをキャッシュすることで、万が一パッケージがパブリックリポジトリから削除された場合も、継続して削除されたパッケージを利用できます。

 ## 独自パッケージの作成と公開
NuGet など、多くのパッケージ形式は、パブリックライブラリからダウンロードするだけでなく、社内で作成し、社内で共有もできます。

BuildMaster などのツールを使えば、プライベートの .nupkg パッケージを作成するときに、CICDも適用できます。

ProGet では、4つの方法で、作成したパッケージを配布できます。

* ディスクからアップロード：パッケージをディスクからアップロードします
* クライアントツールでプッシュ：nuget.exe や npm.exe などのコマンドラインツールを使用して、ローカルフィードにパッケージを追加します
* 別のフィードからプル：同じパッケージタイプの別のフィードからパッケージをプルします。
* パッケージの一括インポート/ファイルコピー：複数の既存のパッケージを一度にインポートします。

フィードにパッケージを追加するには、フィードを選択し [Add Package (パッケージの追加)] ボタンをクリックします。

## パッケージの識別とバージョン管理
名前とバージョンで識別できることは、パッケージの特徴の一つです。バイナリやコードと異なり、あらゆるレベルのエンジニアが読めるので、パッケージの配布がシンプルになります。

ProGet では、原則として、SemVer に準拠したバージョン管理を推奨しています。

## 一般的なパッケージ操作
### パッケージの公開/アップロード
パッケージをProGetに公開またはアップロードするには、ProGet 内で次の手順に従います。

1. フィードを作成するか、ファイルをアップロードするフィードを開きます
2. 右側の [Manage Feed (フィードの管理)] ボタンの横にある▼をクリックします。ロップダウンに「Add Package (パッケージの追加)」と表示されます。
3. ポップアップウィンドウからお好みのアップロード方法を選択します。

### パッケージの削除
ProGetのパッケージを削除または削除するには、ProGet内で次の手順を実行します。
1. 上部のリボンにある [Packages (パッケージ)] タブに移動します。
2. 削除するパッケージの右側にある赤いXをクリックします。
3/ ポップアップウィンドウから「Yes, Delete Package (はい、パッケージを削除します)」を選択します。この操作は元に戻せないのでご注意ください。

:::(Warning) ()
注：フィード内にあるすべてのバージョンをまとめて削除もできます。同じパッケージがほかのフィードにもある場合は、他のフィードにあるパッケージが削除されません。
your content goes here
:::

### リストから外す
「Unlist (リストから外す)」と、正確なURLを入力しない限り、パッケージは表示されなくなります。
注：これは NuGet でのみサポートされています。

### パイプラインでプロモーションする
![ProGet-Pipeline-Promotion](/resources/docs/details-dev-process.gif){height="" width=""}

ProGetのパッケージプロモーションでは、パッケージを品質ごとに分けられます。

パッケージをプロモートすると、パッケージはソースフィードに残り、ターゲットフィードに複製されます。後で「古い」パッケージを手動で削除するか、リテンションルールを設定して自動削除もできます。

パッケージをProGetにプロモートするには、ProGet 内で次の手順に従います。
:::(Internal) ()
Link to package promotion
:::

1. プロモーションしたいパッケージのパッケージ概要ページに移動します。
2. [Download Package (パッケージのダウンロード)] で ▼ にカーソルを合わせ、ドロップダウンから [Promote Package (パッケージのプロモート)] を選択します。
3. ドロップダウンからターゲットフィードを選択します。

詳細については、パッケージプロモーションのドキュメントをご参照ください。