---
title: "Builds & Projects"
order: 2
---

With Projects and Builds in ProGet, you can track the open source and third-party components (packages) your organization uses and apply [Package Policies & Compliance Rules](/docs/proget/sca/policies) to identify vulnerabilities, unwanted license, etc.

![](/resources/docs/proget-build-overview.png){height="" width="50%"}

Projects and Builds will be automatically created when you [integrate ProGet into your CI/CD pipeline](/docs/proget/sca/builds/proget-sca-ci), but you can also create, edit, and delete projects and releases from the web UI or by using the [SCA  API](/docs/proget/api/sca). 

:::(Info) (🔒 ProGet Enterprise Feature)
Although Projects & Builds are available in all editions of ProGet, the feature is limited in ProGet Free and ProGet Basic editions. See [License Restrictions](/docs/proget/administration/license) to learn more.
:::


## What are Projects?
A project represents an application, microservice, or other software component built with open source or third-party software packages. 

![proget-sca-build-timeline](/resources/docs/proget-sca-build-timeline.png){height="" width=""}

Each project will have a number of builds in different stages, and each build will have a number of specific package versions.

### Feeds and Policies
By default, projects will use the ["Global" policy](/docs/proget/sca/policies) to determine whether packages are compliant. However, you can associate a project with feeds and/or policies by navigating to the project, then selecting Edit Project.

When a project is associated with one or more feeds, those feeds' policies will be used to determine compliance. The policies will also restrict access to the Project based on who has access to the Feed.

If you wish to use a different set of policies for your project, this can be done on the Advanced tab by unchecking "Use policies associated with feeds (recommended)", and then specifying the policies to use.


### Applications vs Libraries
:::(Info) (⚙ Best Practices: Use Projects for Deployable Software)
Projects are intended for *deployable* software, not library packages. Although you can use projects for libraries if you really wanted, they aren't a good fit and will likely give you inaccurate and unhelpful results. 
:::

The reason is that libraries do not *contain* other libraries. Instead, they *reference* other libraries by specifying *dependencies* and generally don't reference a specific version.

However, applications *contain* libraries, and when you add a package version to your application, the package manager will add that library and then find specific versions of referenced libraries that will work. Specific package versions are important, because some will versions will contain vulnerabilities while others may not.

For example, your .NET library (let's call it `MyCorp.Utils`) may *reference* [Newtonsoft.Json](https://www.nuget.org/packages/Newtonsoft.Json/), but it will not specify the exact version that's required. When you install  `MyCorp.Utils 3.1.0` into your .NET application, you'll have at least two package versions installed: `MyCorp.Utils 3.1.0` and `Newtonsoft.Json 13.0.3`. Why 13.0.3? Because that's  the latest version available at the time you installed it.

This means that you generally cannot know what specific versions of other library packages a library package will use until you actually try to use it.


## What are Builds?

A build represents a specific version of an application, microservice, or other software component and contains an inventory (a list) of the names and specific versions of third-party and open-source components (packages) that are contained in the build.

Builds are generally created by a CI/CD server like [BuildMaster](/docs/buildmaster/overview), and then deployed into a series of test environments before finally going into production. This process is often called a release pipeline, and it can be visualized as a sequence of environments or stages.

For example, BuildMaster [visualizes a pipeline](/docs/buildmaster/deployment-continuous-delivery/buildmaster-pipelines) as follows:

![](/resources/docs/buildmaster-pipeline.png)

Although ProGet does not model pipelines, you can use build stages and promotions to visualize build progress.

### Build Packages
The Packages tab on the build overview page displays all packages included in the build, their licenses, and security vulnerabilities.

Packages should be added to a build by [uploading an SBOM document](/docs/proget/sca/builds/proget-sca-sbom-importing-exporting) to the project.

If you need to add, remove, or modify packages to a release, navigate to Edit Build > Edit Packages and modify the provided package list. This should be done infrequently, as packages should be added automatically during the build process. You can also delete packages from the Packages tab.


### Build Stages & Promotion
A build's stage shows how far along it is in the release pipeline. When a build is "promoted" to a new stage, not only will it "advance" in the UI, but certain actions may occur: package analysis, changing status, and archiving other builds in that stage.

ProGet includes four build stages (Build, Integration, Test, Production), and you can add additional as needed by navigating to Reporting & SCA >  Projects,  and then hover over the multi-button in the upper right corner and select "Build Stages". From there, you can modify the settings for how builds are handled in each stage (scan for issues, number of active builds to keep, etc.) and create new build stages to match your CI/CD process.

ProGet includes 4 stages out of the box and they are configured to do the following by default:
* **Build**: Archive other builds except the latest 10.
* **Integration**: Archive other builds except the latest 3.
* **Test**: Archive other builds except the latest 3 and create issues for noncompliant packages.
* **Production**: Archive other builds except the latest 1 and create issues for noncompliant packages.

### Status & Archiving
You can archive a build, which means that it will no longer be analyzed or displayed in most lists in the UI. In general, builds should be considered active if they are currently in testing or production, and archived if they will never be deployed or are no longer in use.


:::(Info) (⚙ Best Practices: Make sure to Archive Builds)
Archiving builds is important, as having a lot of active builds will clutter the UI and cause routine build analysis to take longer. 
:::

You can configure build stages to automatically archive other builds upon promotion or use the API to archive builds.


## Build Analysis & Compliance
ProGet will routinely analyze your active builds to make sure that packages are compliant with the vulnerability, license, and other rules you've defined in the associated policies. 

![](/resources/docs/proget-build-overview-warn.png){height="" width="50%"}

The routine analysis is performed by the `ComplianceAnalyzer` scheduled task, which defaults to running on a nightly basis. You can configure the schedule under Administration > Scheduled Tasks.

You can also manually perform an analysis on a build by clicking the `[anaylze]` button in the UI or using the API. 

### Analysis Results
After all packages in a build have been analyzed, the build will generally be considered compliant, noncompliant, or warn. The build's status is based on the "worst" status of its packages. For example, a single noncompliant package in the build will mean that the build as a whole is noncompliant. 

This status can be overridden with issues.

### Inconclusive Analysis
A build package (and thus a build as a whole) can be have an "inconclusive" compliance status. This will occur when two conditions are met:
1) **A rule would cause the build package to be Noncompliant**, such as *Undetected Licenses = Noncompliant* or *Deprecated = Noncompliant*
2) **The package is not cached or otherwise pulled to ProGet**, which means ProGet doesn't have enough information about the package to perform an analysis because the package is

You can resolve this by pulling or downloading (i.e. caching) the package in a feed in ProGet, or not defining rules that require server-based metadata. For example, vulnerability-based rules can be checked without the package, but deprecation or license detection cannot.

:::(Info) (⚙ Best Practices: Use Exceptions for System/Platform Packages)
You may find that some "platform" packages, like `runtime.*` NuGet packages, appear in builds, even though they're never installed into your project or downloaded/consumed from ProGet. 

Although you can still pull these into ProGet to work around an inconclusive analysis, they're not typical open source packages and will not have deprecation or license issues. Consider using an exception instead.
:::

In general, you should not encounter inconclusive results because the package metadata should already be in ProGet by the time the build is added. This is because a package restore/installation from a ProGet feed will cause the packages will be cached automatically. 

## Build Issues & Overriding Compliance

When builds in certain stages are analyzed, an "Issue" for each noncompliant or inconclusive package will be created. These are intended to allow a human review and override noncompliant packages.

![](/resources/docs/proget-build-issues.png)

An issue can then be fixed in one of two ways:
* Automatically resolved; the next time ProGet analyzes the build and the package is no longer noncompliant, the issue will be automatically resolved
* Manually resolved; a user can mark an issue as resolved after determining that the package compliance has no impact on the build

If an issue is manually resolved, the package's compliance status will *not* be used to determine the build's compliance status.

Issues can also be deleted, but they will then probably reappear in the next release analysis.


## ProGet 2023 and earlier
Projects & Builds are available as a feature in ProGet 2024 as a replacement feature for [Project and Releases (archive.org)](https://web.archive.org/web/20230531170947/https://docs.inedo.com/docs/proget-sca-projects-releases). The features are substantially similar:
* "Releases" were renamed to "Builds" because they  reflects a better model for to CI/CD
* Builds also include a release number and a stage, and are automatically archived

Issues also worked a little differently, in that they were "typed" and there was a "missing package" issue that would often crop up. See [Releases Analysis & Issues
 (archive.org)](https://web.archive.org/web/20230531171431/https://docs.inedo.com/docs/proget-sca-release-issues) to learn more.

When upgrading to ProGet 2024, the "Releases" created will be automatically copied to Builds. If you downgrade to ProGet 2023, the "Releases" will still be there, but no new Builds will be.