---
title: "Promote Package"
order: 8
---

The *Promote Package API*  is available as both a `pgutil` command and an HTTP Request, and will [promote packages](/docs/proget/packages/package-promotion) in package-based feeds, regardless of the package type:

:::(Info) (🚀 Quick Example: Promoting a NuGet package with pgutil)
This example promotes a package (`myNugetPackage`, version `1.2.3`) from one feed (`nuget-unapproved`) to another (`nuget-approved`)

```bash
pgutil packages promote --feed=nuget-unapproved --to-feed=nuget-approved --package=myNugetPackage --version=1.2.3
```
:::

:::(info) (Query Promoted Packages)
The commands and HTTP Requests below promotes packages. To query promoted packages, see [Query Package Promotions](/docs/proget/api/packages/promote/promotion-query), which can be used to return data of previously promoted packages.
:::

This API requires ProGet 2023.0 or later.

## Command Specification (CLI)
The `packages promote` command is used to promote a package from one feed to another.

The `--package` and `--version` options are always required. The `--feed` option is required if a default feed is not configured, and the  `--to-feed` option is required to promote a feed other than the original feed.

**Promoting an npm Package** requires the feed to promote from (e.g. `unapproved-npm`), the feed to promote to (e.g. `approved-npm`), name (e.g. `@myscope/my-npm-package`) and version (e.g. `2.0.0`):

```bash
pgutil packages promote --feed=unapproved-npm --to-feed=approved-npm --package=@my-scope/my-npm-package --version=2.0.0
```

Note source options must also be specified unless you have the "Default" source configured, and that a feed may be instead specified in the source. See [Working with Sources](/docs/proget/api/pgutil#sources) to learn more.

### HTTP Request Specification
To promote a package, simply `POST` to the URL with an [appropriate API Key](/docs/proget/api/packages#authentication) and a [PromotePackageInput](/docs/proget/api/packages#promotion) JSON object as the request body.

:::(info) 
For npm feeds, `group` should be the package scope (e.g. `@mycompany` or `@vue`). 

For Docker registries, `name` should be the full repository name (e.g., `bitnami/dotnet`) and version should be the tag (e.g., a version number).
:::

```plaintext
POST /api/promotions/promote
```

Alternatively you can promote a package as a URL encoded request using form-encoded values:

```plaintext
POST /api/promotions/promote Content-Type: application/x-www-form-urlencoded

name=«package-name»&group=«scope-name»&version=«version»&fromFeed=«from-feed-name»&toFeed=«to-feed-name»&comments=«comments»
```
«»

### HTTP Response Specification

| Response | Details |
| --- | --- |
| **200 (Success)** | the package was promoted |
| **400 (Invalid Input)** | indicates invalid or missing properties on the package; the body will provide some details as text |
|  **403 (Unauthorized API Key)** | indicates a [missing, unknown, or unauthorized API Key](/docs/proget/api/packages#authentication) |

