---
title: "What is a Variable in BuildMaster?"
order: 2
---

:::(Internal) (TODO)
- retake screenshots (they were from Otter)
:::
Using variables, you can create reusable scripts that can deploy the same application to multiple environments and prompt users for parameters before creating or deploying the application.

Essentially, variables can be used in place of any value that you might want to change when your script is run, such as:
* Directory where an application is located
* Service or application pool name to stop/start before deployment
* Project name you wish to build
* User account a service runs under
* Name of a certificate to install
* Port that a website should use
* Email address to send a notification to

## What is a Variable in BuildMaster?
Variables can refer to several different things inside of BuildMaster.

| Type | Description |
| --- | --- |
| **Configuration&nbsp;Variables** | are static values  that you can set on applications, releases, builds, servers, roles, environments, or globally. You can add these from the UI, through the API, or using an operation in OtterScript. |
| **Variable&npbs;prompts** | are [defined in a pipeline](/docs/buildmaster/otterscript-execution-engine/buildmaster-variables/buildmaster-variable-prompts) to prompt a user for input when they create or deploy a build; these are displayed as input fields and are validated. |
| **Variable functions** | predefined functions like `$Date()` or `$ServerName()` that will automatically change depending on when and where you scripts are run; although the parentheses are optional, some variable functions take parameters, like `$FileExists(fileName)`.<br /><br/> You can create your own variable functions with the [Inedo SDK](/docs/inedosdk/versions-release-notes). |
| **Runtime variables** | these exist [within your OtterScript script](/docs/otter/scripting-in-otter/otter-configuration-variables) and behave like variables in programming languages; they are intended to help you create advanced programming logic in your scripts |


## Working with Configuration Variables 
**Configuration variables** are static values that you can set on a number of different components within BuildMaster: applications, releases, builds, application groups, servers, server roles, environments, or globally. 

You can add these from the UI, through the API, or using an operation in OtterScript. When you create a build using a pipeline, the Variable Prompts defined will also create configuration variables on the build or release.

### Editing Variables in BuildMaster's UI 
You can define variables by going to the desired context (such as the specific application or server) and then adding a single one. You can also bulk edit all variables in that context.

![](/resources/docs/Editing-Variables-in-Otter's-UI-01.png){height="" width=""}

You can view all configuration variables across all contexts by navigating to Admin > Configuration Variables.  This also lets you bulk edit all variables in Otter.

![](/resources/docs/Editing-Variables-in-Otter's-UI-02.png){height="" width=""}
 
### Hiding & Obscuring Values 
Configuration variables include the option to obscure the value of this variable from casual viewing.  As the name implies, this only obscures the value by replacing it with (hidden) in the user interface. It is not intended for passwords, nor should this be used as a security feature. 

:::(Warning)
Do not store sensitive information in variables; use [secure credentials](/docs/buildmaster/configuring-for-your-team/buildmaster-administration-resource-credentials) instead.
:::
 
### Variables inside of Other Variables 
When creating a configuration variable, there is an option to "Evaluate the value of this variable will be as if you ran $Eval() over it". 

This option instructs BuildMaster to evaluate variable expressions inside of your variable, which means that you can reference one variable from within another. This can help simplify the configuration variables you maintain in BuildMaster across many environments, servers, server roles, etc.

For example, let's say that you had dozens of servers that need to have the `FooBar` and `MyBar` applications installed, and you wanted them installed in a mostly consistent manner. You could set up configuration variables as follows:

| Scope | Name | Value |
| --- | --- | --- |
| Global | `$AppsDrive` | `D:\` |
| Global | `$WebSiteRoot` | `$PathCombine($AppsDrive, WebSites)` |
| Environment<br/>(Production) | `$AppsDrive` | `F:\` |
| Server Role<br/> (FooBar) | `$FooBarAppPath` | `$PathCombine($WebSiteRoot, $EnvironmentName, FooBar)` |
| Server Role<br/> (MyBar) | `$MyBarPath` | `$PathCombine($WebSiteRoot, $EnvironmentName, MyBarApp)` |

With this scheme, on a production server with the `MyBar` role, the `$MyBarPath` variable would resolve to `F:\Production\MyBarApp`. This simplifies having to define the configuration variable over and over again.



## Using the API to Read or Set Variables 
You can use the [Variables Management API](/docs/otter/reference/api/variables) to programmatically read and set variables in Otter. This allows external scripts and programs to see the values you've defined, as well as set them on environments, servers, server roles, etc.

```PowerShell
# Get value of FooBarVersion on FooBar role
$foobarVersion = Invoke-WebRequest -URI https://my-otter.corp.local/api/variables/role/foobar/FooBarVersion?key=$myApiKey

# Set value of FooBarVersion if doesn't exist
if (!$foobarVersion) {
  Invoke-WebRequest -URI https://my-otter.corp.local/api/variables/role/foobar/FooBarVersion?key=$myApiKey -Method 'POST' -Body '3.2.4'
}
```
Note that `$myApiKey` refers to an [API Key](/docs/otter/configuring-for-your-team/otter-administration-security-api-keys) that you'll need to set before use.

## Using OtterScript to Set Configuration Variables 

You may wish to have your scripts set variables on builds, or other items in BuildMaster. This can be a convenient way to store information such as URLs, versions, or other values you may need later.

For example, you could use the `Set-BuildVariable` operation to create or modify the `$CIWebUrl` variable on the current build.

```
Set-BuildVariable CIWebUrl
(
    Value: https://ci-$ReleaseNumber.$BuildNumber.hdarapp.corp.local/
);
```

You could set values on different builds by setting the `Application`, `Release`, and `Build` parameters of that operation.

Similarly, the `Set-ReleaseVariable` will create or modify a variable on the current release, or you could set the `Application` or `Release` parameter to target a different release.

The `Set-ConfigurationVariable` operation will allow you to create configuration variables on all other items. 

```
Set-ConfigurationVariable  «variable-name»
(
    Server: «server-name»,
    ApplicationGroup: «application-group-name»,
    Application: «application-name»,
    Environment: «environment-name»,
    ServerRole: «server-role-name»,
    Value: «variable-value»
);
```



## Multiple and Cascading Variable Values 
Configuration variables cascade, which means that you can define a variable of the same name in multiple places and the correct value will be resolved at runtime.  

For example, if you define a variable named `$HDarsPath` on the `testing` environment, when an deploy script runs against a server in the testing environment, that variable will resolve at runtime. If you also defined `$HDarsPath` on a single server in the `testing` environment, that value would be used instead. This allows for reusing scripts without having to change local variables. 

### Resolution Rules
The variable definition that's the closest match to the current context is used. This is determined as follows:

1. Runtime Variables (set in OtterScript)
2. Deployment Variables (set by Deploy-scoped Pipeline Variable Prompts)
3. Build Variables
4. Release Variables
5. Application
6. Application Group
7. Server
8. Server Role
9. Environment
10. Global

For example, the variable `$UserName` could be defined as Admin at the global-level but as Administrator at the server-level for IntSv03. When calling the variable in a job on IntSv3, the variable will be defined as Administrator instead of Admin.

### Multiple Scopes

You can assign multiple scopes to a configuration variable; for example, you could define a variable that's associated with _both_ the `testing` environment and the `hdars-web` role. A multi-scope variable simply adds precedence to the highest-scope (deployment is still closer than a Environment + Application).

:::(Error) 
Assigning multiple scopes to a single configuration variable can become confusing as the resolution rules are not intuitive. We generally discourage this use.

You can only create multi-scoped variables from the administration section, and they are visible (but not editable) on the servers, server roles, etc. that they are associated with. 
:::


## Variables API

Variables are configurable using the [Variables Management API](/docs/buildmaster/reference/api/variables).
