---
title: "NuGet (.NET) Packages and Feeds in Proget"
nav-title: "NuGet (.NET)"
order: 3
---

NuGet is the package manager for .NET and a NuGet feed allows client tools like Visual Studio to consume and publish NuGet and symbol packages.

You can also [use a NuGet Feed as a proxy for NuGet.org](/docs/proget/feeds/nuget/howto-nuget-proxy), both to block [improper licenses](/docs/proget/sca/licenses) and [security vulnerabilities](/docs/proget/sca/vulnerabilities), and to cache packages in case the Internet or NuGet.org goes down.

## Authenticating to NuGet Feeds { #authenticating-to-feed }

By default, NuGet feeds in ProGet do not need to be authenticated to when consuming packages. However, if your feed requires authentication to view and download packages, then you'll need to configure an *authenticated* source when adding the feed.

::: (Info) (💡 Best Practices: Use API Keys for Authenticated Feeds)
Instead of using your ProGet username/password for a NuGet feed, we recommend [Creating a ProGet API Key](/docs/proget/api/apikeys) to authenticate. You can enter `api` as the username and your key as the password.
:::

When an authenticated feed is added to Visual Studio, you'll be prompted for a username and password. You can enter `api` for the username and your api key as the password:

![visualstudio-connecttoserver-inputted.png](/resources/docs/visualstudio-connecttoserver-inputted.png){height="" width="50%"}

Or, you can use the `--username` and `--password` arguments in the NuGet CLI:

```bash
$ dotnet nuget add source --name "Internal NuGet" --username api --password abcdef12345 https://proget.corp.local/nuget/internal-nuget
```

See the [NuGet CLI sources command](https://learn.microsoft.com/en-us/nuget/reference/cli-reference/cli-ref-sources) to learn more.

### Authentication for Publishing Packages { #authenticate-cli }

If you use the NuGet CLI to push packages to ProGet, you'll need to *also* specify an `--api-Key` argument. 

You can also add an API key to a source using the `setApiKey` command:

```bash
$ dotnet nuget setApiKey «api-key» -Source «feed-url»
```

The NuGet CLI only uses this setting for pushing packages; it will be ignored when viewing/downloading packages, which means you'll also need to add an authenticated source.

## Creating and Publishing NuGet Packages 

The [NuGet package format](https://docs.microsoft.com/en-us/nuget/schema/nuspec) is well-documented, and you can create packages in a number of ways, including [directly from Visual Studio](https://docs.microsoft.com/en-us/nuget/guides/create-net-standard-packages-vs2017) or using [using the NuGet CLI](https://docs.microsoft.com/en-us/nuget/create-packages/creating-a-package). 

However, many users find it easiest to publish packages using [pgutil](/docs/proget/api/pgutil). This requires some [minor configuration](/docs/proget/api/pgutil#sources) before use, but allows you to more easily specify different feeds.

For example, to upload the package `My.Package.1.0.0.nupkg` stored at `bin\publish` to your `internal-nuget` feed you would enter:

```bash
$ dotnet nuget setApiKey «api-key» -Source «feed-url»
```

The NuGet CLI only uses this setting for pushing packages; it will be ignored when viewing/downloading packages, which means you'll also need to add an authenticated source.

## Creating and Publishing NuGet Packages 

The [NuGet package format](https://docs.microsoft.com/en-us/nuget/schema/nuspec) is well-documented, and you can create packages in a number of ways, including [directly from Visual Studio](https://docs.microsoft.com/en-us/nuget/guides/create-net-standard-packages-vs2017) or using [using the NuGet CLI](https://docs.microsoft.com/en-us/nuget/create-packages/creating-a-package). 

However, many users find it easiest to publish packages using [pgutil](/docs/proget/api/pgutil). This requires some [minor configuration](/docs/proget/api/pgutil#sources) before use, but allows you to more easily specify different feeds.


:::(info) (Example:)
To upload the package `My.Package.1.0.0.nupkg` stored at `bin\publish` to your `internal-nuget` feed you would enter:

```bash
$ pgutil packages upload --feed=internal-nuget --input-file=bin\publish\My.Package.1.0.0.nupkg
```
:::

Your package will then be uploaded to the `internal-nuget` feed. To learn more about creating and publishing packages, see [HOWTO: Publish NuGet Packages to a Private Repository in ProGet](/docs/proget/feeds/nuget/howto-nuget-publish).

## Symbols and Source Packages 

A NuGet feed in ProGet may be configured as a Symbol/Source server compatible with debuggers such as Visual Studio and WinDbg. This will allow you to "step through" code in your NuGet package as if it were in the project.

![](/resources/docs/symbol-server-config-dialogbox.png)

Configuring this is a bit more involved than simply enabling that feature on your feed, and requires creating special NuGet symbol packages and then configuring Visual Studio to use those packages. See [Symbols and Source Code in ProGet](/docs/proget/feeds/nuget/symbol-and-source-server) to learn more.

## Vulnerability Integration
Beginning in ProGet 2023.5, we have added support to show [vulnerability information](https://devblogs.microsoft.com/nuget/how-to-scan-nuget-packages-for-security-vulnerabilities/) directly in Visual Studio and the NuGet CLI.  You will see the severity of your vulnerability along with a link to see the vulnerability details in ProGet.

When selecting a package version with a vulnerability in Visual Studio, you will see the severity with a clickable link to the vulnerability in ProGet.

![](/resources/docs/proget-nuget-vulnerability-visual-studio.png){height="" width=""}

When running `dotnet list package --vulnerable` in the NuGet CLI, you will see a list of vulnerable packages with their severity and a link to the vulnerability in ProGet.

![](/resources/docs/proget-nuget-vulnerability-nuget-cli.png){height="" width=""}

![](/resources/docs/proget-nuget-vulnerability-nuget-cli.png){height="" width=""}

:::(INFO)
⚠ ProGet Free edition limits vulnerability information shown in Visual Studio and the NuGet CLI.
:::(INFO)
⚠ ProGet Free edition limits vulnerability information shown in Visual Studio and the NuGet CLI.
:::

## Managing Package Deprecation and Unlisting

ProGet will show deprecation information directly in Visual Studio and the NuGet CLI. You will see if a specific version of the package was deprecated along with the specified reason. This works for both packages that come from a NuGet connector and packages that were deprecated using the ProGet UI.

When selecting a package version that has been deprecated in Visual Studio, you will see a warning that the package has been deprecated. If the package has been installed in your project, you will also see a shield in the package list.

![](/resources/docs/nuget-deprecated-visualstudio.png){height="" width=""}

When running `dotnet list package --deprecated` in the NuGet CLI, you will see a list of deprecated packages installed in your project along with the deprecation reason.

![](/resources/docs/nuget-deprecated-cli.png){height="" width=""}

Visual Studio and the NuGet CLI heavily caches this information and may take time to show this information after a package has been marked as deprecated. Due to this caching, parts of Visual Studio (version drop-down, version details, and package list) may show the deprecation information at different times. 

To force the NuGet CLI to update its deprecated packages, you will need to first clear the NuGet HTTP Cache using the command: 

```bash
`dotnet nuget locals http-cache --clear`
```

Then the next time you run `dotnet list package --deprecated,` the deprecation information will show immediately.

To force Visual Studio to update its deprecated packages, you will need to navigate to "Tools" > "Options" > "NuGet Package Manager" > "General" and then click "Clear All NuGet Storage". This will clear the entire NuGet cache (including cached packages) from the machine and then the deprecated information will show immediately.

In addition to marking packages as deprecated, ProGet allows you to unlist or delete packages from your feed:

### Unlisting Packages

Unlisted packages will no longer appear in most search results or Visual Studio. However, these packages can still be installed if the exact version number is specified, making it a useful option for deprecated or outdated packages you want to limit to advanced users.

To unlist a package you can use the [`packages status unlisted`](/docs/proget/api/packages/status) command in [pgutil](/docs/proget/api/pgutil). For example, if unlisting version `1.2.3` of the package `MyPackage` from the feed `internal-nuget` you would enter:

```bash
$ pgutil packages status unlisted  --feed=internal-nuget --package=MyPackage --version=1.2.3 --state=listed
```
## Troubleshooting

### My CI build can’t find a recently published package
The NuGet client maintains a 30-minute HTTP cache for package restore responses. In situations where you deploy more than one new version of a package within 30 minutes, and produce a CI build referencing each of those packages within that 30-minute window, your build will likely fail with a package not found error. This is a known issue in NuGet, and can be worked around by deleting the http cache on your build server prior to restoring packages:

```bash
$ dotnet nuget locals http-cache --clear
```

See [NuGet GitHub Issue 3116](https://github.com/NuGet/Home/issues/3116) for more information about this error.