---
title: "SCA (Builds & Projects)"
order: 8
---

The Software Composition Analysis (SCA) API has to query, create, and update projects, builds, and related components on a ProGet instance.
All http requests are made through the following base URL:

:::(info)
 `/api/sca/...`
:::

### 🏗 Builds { #builds-endpoints }

[Create/Update Build](/docs/proget/api/sca/builds/create) - Creates or updates a build
[Get Build](/docs/proget/api/sca/builds/get) - Describes a specified build
[List Build](/docs/proget/api/sca/builds/list) - Lists and describes specified build
[Analyze Build](/docs/proget/api/sca/builds/analyze) - Runs an analysis on a specified build
[Promote Build](/docs/proget/api/sca/builds/promote) - Promotes a build to a specified stage
[Scan Build](/docs/proget/api/sca/builds/scan) - Generates a minimal SBOM from project dependencies*

*\* Only available as a pgutil command.*

### 🛠️ Projects { #projects-endpoints }

[Create/Update Project](/docs/proget/api/sca/projects/create) - Creates or updates a project
[Get Project](/docs/proget/api/sca/projects/get) - Describes a specified project*
[List Projects](/docs/proget/api/sca/projects/list) - Lists and describes specified projects

*\* Only available as an HTTP request.*

### 🚩 Issues { #issues-endpoints }

[List Issues](/docs/proget/api/sca/issues/list) - Lists and describes specified issues
[Delete Issues](/docs/proget/api/sca/issues/delete) - Deletes a specified issue
[Resolve Issue](/docs/proget/api/sca/issues/resolve) - Sets a specified issue to resolved

### 💬 Comments { #comments-endpoints }

[Create/Update Comment](/docs/proget/api/sca/comments/create) - Creates or updates a comment
[List Comments](/docs/proget/api/sca/comments/list) - Lists and describes specified comments
[Delete Comment](/docs/proget/api/sca/comments/delete) - Deletes a specified comment

### 📄 SBOM Document { #SBOM-endpoints }

For managing ["Software Bill of Material"](/docs/proget/sca/builds/proget-sca-sbom-importing-exporting#what-is-a-software-bill-of-materials-sbom) (SBOM) documents

[Export SBOM](/docs/proget/api/sca/sbom/export) - Exports a SBOM document from ProGet
[Import SBOM](/docs/proget/api/sca/sbom/import) - Imports a SBOM document to ProGet*

*\* Only available as an HTTP request.*

## Authenticating to SCA Repository API { #authentication }

The following is a summary of access types and their corresponding requirements for various API key types and endpoints within this API.

| Access Type | Requirements |
| --- | --- |
| System API Keys | `Manage Builds & Projects` and/or `Upload SBOM documents`
| Feed API Keys | *not usable*
| Personal API Key |  associated user must have one of: <br />&bull; `Projects_View` <br />&bull; `Projects_ResolveIssue`<br />&bull; `Projects_UploadSbom`<br />&bull; `Projects_Manage`
| No API Key | anonymous or authenticated user must have at  one of the above permissions

To specify an API Key, use the request header (`X-ApiKey`), querystring (`key`), or `api:«api-key»` as the username. See [API Key Usage](/docs/proget/api/apikeys#using-api-keys) to learn more.

:::(Info) (🚀 Quick Example: Authenticating with curl)
For example, to authenticate with the API key `abc12345` to [List Projects](/docs/proget/api/sca/projects/list), you could specify the API key as follows:

```plaintext
curl -X GET -H "X-ApiKey: abc12345" "https://proget.corp.local/api/sca/projects"
```

If the provided API key is either missing, unknown/incorrect, or does not have permission, the following message is returned:

```plaintext
403 The specified API key does not have the proper permissions to perform this action.
```
:::

## Data Specifications  { #data-specifications }

### ProjectInfo Object Properties { #projectinfo-object }
`ProjectInfo` is a JSON object (see [ProjectInfo](https://github.com/Inedo/pgutil/blob/thousand/Inedo.ProGet/ProjectInfo.cs)) that correspond to the fields on a Project. It's used as both input and output data for [Create/Update Project](/docs/proget/api/sca/projects/create) and output data for [List Projects](/docs/proget/api/sca/projects/list).

Note that some values are optional (indicated by `string?`), and may be set to `null` or an empty string.

#### Example JSON Object
```json
[
  {
    "id": 2,
    "name": "myProject",
    "url": "proget.corp.local"
  },
  {
    "id": 1,
    "name": "myApplication",
    "type": "Application"
  }
]
```

### BuildInfo Object Properties { #buildinfo-object }

`BuildInfo` is a JSON object (see [BuildInfo](https://github.com/Inedo/pgutil/blob/thousand/Inedo.ProGet/BuildInfo.cs)) that corresponds to the fields on a build. It's used as both input and output data for  [Create/Update Build](/docs/proget/api/sca/builds/create), and output data for [Get Build](/docs/proget/api/sca/builds/get) and [List Builds](/docs/proget/api/sca/builds/list)

Note that some values are optional (indicated by `string?`), and may be set to `null` or an empty string.

#### Example JSON Object
```json
{
    "project":"myProject",
    "version":"1.2.3",
    "active":true,
    "viewBuildUrl":"http://proget.corp.local/projects/release?projectReleaseId=2",
    "viewIssuesUrl":"http://proget.corp.local/projects/release/issues?projectReleaseId=2",
    "comments": [ ], // Refer to BuildComment object
    "packages": [ ] // Refer to BuildPackage object
}
```

### BuildPackage Properties { #packageinfo-object }

`BuildPackage` is a JSON object (see [BuildPackage](https://github.com/Inedo/pgutil/blob/thousand/Inedo.ProGet/BuildPackage.cs)) used as a parameter on a [BuildInfo](#buildinfo-object") object. It corresponds to the fields on a Package and is used as both input and output data for  [Create/Update Build](/docs/proget/api/sca/builds/create), and output data for [Get Build](/docs/proget/api/sca/builds/get) and [List Builds](/docs/proget/api/sca/builds/list)

#### Example JSON Object
```json
[
    {
      "purl": "pkg:nuget/Newtonsoft.Json@12.0.3",
      "licenses": [ "MIT" ],
      "compliance": { }, // Refer to BuildPackageComplianceInfo object
      "vulnerabilities": [ ] // Refer to BuildPackageVulnerability object
    },
    { ... }
  ]
```

### BuildPackageVulnerability Properties { #vulninfo-object }

`BuildPackageVulnerability` is a JSON object (see [BuildPackageVulnerability](https://github.com/Inedo/pgutil/blob/thousand/Inedo.ProGet/BuildPackageVulnerability.cs)) used as a parameter on a [BuildPackage](#packageinfo-object") object. It corresponds to the fields on a Package Vulnerability and is used as both input and output data for  [Create/Update Build](/docs/proget/api/sca/builds/create), and output data for [Get Build](/docs/proget/api/sca/builds/get) and [List Builds](/docs/proget/api/sca/builds/list)

#### Example JSON Object
```json
[
    {
      "id": "PGV-2245804",
      "title": "Improper Handling of Exceptional Conditions in Newtonsoft.Json",
      "description": "Description of the vulnerability in markdown",
      "score": 7.5,
      "assessment": "Blocked"
    },
    { ... }
]
```

### BuildPackageComplianceInfo Properties { #complianceinfo-object }

`BuildPackageComplianceInfo` is a JSON object (see [BuildPackageComplianceInfo](https://github.com/Inedo/pgutil/blob/thousand/Inedo.ProGet/BuildPackageComplianceInfo.cs)) used as a parameter on a [BuildPackage](#packageinfo-object") object. It corresponds to the fields on a Package's compliance information and is used as both input and output data for  [Create/Update Build](/docs/proget/api/sca/builds/create), and output data for [Get Build](/docs/proget/api/sca/builds/get) and [List Builds](/docs/proget/api/sca/builds/list)

#### Example JSON Object
```json
{
    "result": "Noncompliant",
    "detail": " because of Vulnerability (PGV-2245804).",
    "date": "2024-07-11T08:53:41.827Z"
},
```

### IssueInfo Properties { #issueinfo-object }

`IssueInfo` is a set of key/value pairs that correspond to the fields on an Issue. It's used as output data for [List Issues](/docs/proget/api/sca/issues/list), returning `IssueInfo` as a JSON-formatted object.

Note that some values are optional (indicated by `string?`), and may be set to `null` or an empty string.

#### Example JSON Object
```json
{
    "project": "myProject",
    "version": "1.2.3",
    "number": 123,
    "created": "2024-01-23T12:00:00Z",
    "type": "V",
    "purl": "pkg:myGroup/myPackage@v1.2.3",
    "vulnerability": "12345"
}
```

### BuildComment Object Properties { #comment-info }

`BuildComment` is a JSON object (see [BuildComment](https://github.com/Inedo/pgutil/blob/thousand/Inedo.ProGet/BuildComment.cs)) that corresponds to the fields on a Comment. It's used as both input and output for [Create/Update Comment](/docs/proget/api/sca/comments/create), and output for [List Comments](/docs/proget/api/sca/comments/list).

Note that some values are optional (indicated by `string?`), and may be set to `null` or an empty string.

#### Example JSON Object
```json
{
    "number":1,
    "by":"proget",
    "date":"2024-01-24T02:10:36.993Z",
    "comment":"I am a new comment."
}
```