---
title: "API Endpoints & Methods"
order: 13
---

ProGet provides a variety of API methods and endpoints to upload/download packages, manage feeds, audit package compliance, assess vulnerabilities, etc.

The easiest way to work with the ProGet API is by using [pgutil](#pgutil) a cross-platform Command-line Interface (CLI) tool. You can also use [HTTP Endpoints](#http) and the [.NET library (NuGet package)](#dotnet) that `pgutil` uses under-the-hood.

## pgutil Command-line Interface { #pgutil }

`pgutil` is an [open-source (github.com)](https://github.com/inedo/pgutil), cross-platform command line tool that's easy to download and install.


:::(info) (🚀 Quick Installation Guide for pgutil)
If you've already got `dotnet` installed, just run this command to [install the tool locally](https://docs.microsoft.com/en-us/dotnet/core/tools/global-tools).

```Batchfile
dotnet tool install pgutil
```
You can also download stand-alone executable for Windows and Linux on the [pgutil GitHub Releases page](https://github.com/Inedo/pgutil/releases).
:::

Once you've installed pgutil, you can simply type `pgutil help` to get a list of all of the commands and options available. You can also [register sources](/docs/proget/reference-api/proget-pgutil#sources) so that you don't always have to specify urls, feeds, and API keys, etc.

:::(info) (🚀 Quick pgutil Example: Uploading a Package)
```
pgutil packages upload --source=corpx-dev --input-file=Newtonsoft.Json.13.0.3.nupkg
```
:::
See the [Getting Started with pgutil](/docs/proget/reference-api/proget-pgutil) guide to learn more.

## HTTP Endpoints { #http }

Although we recommend using [pgutil](/docs/proget/reference-api/proget-pgutil) for programmatic access to ProGet, you can also use the HTTP Endpoints that `pgutil` uses for your own scripts and programs. This may be particularly helpful if you need to work with structured data or wish to create a more advanced integration.

:::(info) (🚀 Quick HTTP Example: Download a Package)
```
GET /api/packages/MyNugetFeed/download?name=MyNugetPackage&version=1.0.0
```
:::

 See the [Getting Started with HTTP Endpoints](/docs/proget/reference-api/proget-api-http) guide to learn more.

## .NET library (NuGet package) { #nuget }

The [Inedo.ProGet NuGet Package](https://www.nuget.org/packages/Inedo.ProGet) is basically the .NET-library version of `pgutil`. It's built from the [pgutil GitHub code/repository](https://github.com/Inedo/pgutil/tree/thousand/Inedo.ProGet) and is mostly a HTTP Client that wraps the HTTP Endpoints.

We've tried the keep the library really easy to use. You just need to instantiate the `ProGetClient` class with authentication information and then invoke methods that call HTTP Endpoints. 

For example, here is how you would delete a package:
```
var packageToDelete = new PackageIdentifier                                                            
{                                                                                                      
    Feed = "myNuGetFeed",                                                                              
    Name = "myPackage",                                                                                
    Version = "4.2.1"                                                                                  
};                                                                                                     
var client = new ProGetClient("https://proget.corp.local", "c169a14be6e0c36f2f195fe9d3de9b77af5f8dd5");
await client.DeletePackageAsync(packageToDelete, cancellationToken);                                   
```

Like many other methods, `DeletePackageAsync` has a structured input called `PackageIdentifier`. 

:::(Info) (💡 PROTIP: Look at how we use `ProGetClient`)
The best way to learn how we use `ProGetClient` is by studying the `pgutil` code.  For example, the [DeleteCommand.cs](https://github.com/Inedo/pgutil/blob/thousand/pgutil/Packages/DeleteCommand.cs)) is a great starting point for seeing how user input is transformed into HTTP input.
:::

Like the HTTP Endpoints, the `Inedo.ProGet` library is developed using a *pgutil-first* approach. This means we will prioritize the CLI experience by creating intuitive and self-documenting commands, and then add methods to the `ProGetClient` and new HTTP Endpoints as needed.

We're still very open to improving the developer experience of the `Inedo.ProGet` library, and we're happy to work closely with users to do that. Just post to the [Inedo Forums](https://forums.inedo.com/) if you have feedback, suggestions, issues, etc. You can also make a Pull request.