---
title: "Statements and Code Blocks"
order: 1
---

In OtterScript, Statements and Code Blocks are the core building elements that define the logic and flow of your deployment plans. The execution engine processes plans in a top-down manner, interpreting one statement at a time and managing blocks according to their structure and type.

If you're familiar with programming or scripting concepts, OtterScript’s approach will feel intuitive. However, it also introduces unique features such as log scoping, asynchronous execution, and isolated processes to better suit deployment and infrastructure automation needs.

## Statements

Statements are individual actions or directives within a plan.

Most statements are operations, but OtterScript also provides control and flow statements like:
* Set Variable – define or update values
* Log – write messages to the execution log
* Set Status – manually change the execution status
* Raise Error – explicitly trigger an error
* Await – pause execution to wait for asynchronous processes

Statements execute sequentially unless the plan’s flow is altered by blocks or specific flow control.

## Code Blocks

Blocks group statements together and manage their execution context. Blocks provide:
* Flow control (e.g., conditional branching, loops, error handling)
* Variable and log scoping
* Parallel and exclusive execution
* Error isolation and retry logic

There are several types of code blocks:

| Block Type | Purpose |
|------------|---------|
| [General Blocks](/docs/executionengine/coreconcepts/statements-blocks/general) | Group statements with shared execution settings, like server targeting or async execution |
| [If/Else Blocks](/docs/executionengine/coreconcepts/statements-blocks/if-else) | Branch execution based on a condition |
| [For Each Blocks](/docs/executionengine/coreconcepts/statements-blocks/for-each) | Loop through items like arrays or ranges |
| [Try/Catch Blocks](/docs/executionengine/coreconcepts/statements-blocks/try-catch) | Handle errors gracefully and execute fallback actions |
| [Other Code Blocks](/docs/executionengine/coreconcepts/statements-blocks/other) | Statements for setting variables, logging, setting statuses, etc. |

Each block introduces a new scope for both variables and logging, meaning:
* Variables declared inside a block are isolated to that block (and its nested blocks).
* Logs for actions inside a block can be collapsed or expanded in the execution logs, making plans easier to debug and understand.

## Visual and Text Modes

You can define statements and blocks either:

* **Text Mode:** Gives full flexibility and is better suited for advanced users or bulk editing.

<image>

* **Visual Mode:** A graphical user interface for building plans intuitively.

<image>

Both modes are fully interchangeable.

## Advanced Control

OtterScript also supports advanced features like:
* [Asynchronous execution](/docs/executionengine/coreconcepts/statements-blocks/general#asynchronous): run blocks in the background
* [Exclusive execution](/docs/executionengine/coreconcepts/statements-blocks/general#exclusive): prevent concurrent execution of certain operations
* [Retry on error](/docs/executionengine/coreconcepts/statements-blocks/try-catch#retry): automatically reattempt operations when they fail
* [Isolation](/docs/executionengine/coreconcepts/statements-blocks/general#isolation): run remote operations in clean, temporary processes

These features are configured through properties on General Blocks and can dramatically enhance reliability and performance in large-scale deployments.