---
title: "Manual Installation"
order: 3
---

:::(Error) (💀 Manual Installations are Not Supported 💀)
This document is for informational and troubleshooting purposes only and there is no good reason to install an Inedo product manually.

Not only can we not provide installation support, but both you and your successor will have a very hard time maintaining this installation. In addition, the instructions in this document are untested and probably outdated.
:::

### Table of Contents

 - [Prerequisites](#prerequisites)
 - [Database Installation (SQL Server)](#database-installation-sql-server)
 - [Website Installation (IIS)](#website-installation-iis)
 - [Service (Windows Service)](#service-windows-service)
 - [First Run](#first-run)
 - [Extensions](#extensions)
 - [Upgrading an Existing Inedo Product Installation](#upgrading-an-existing-inedo-product-installation)
 - [Troubleshooting](#troubleshooting)

### Software Components
On Windows, Inedo products consist of 3 different deployable application components that are required to run the software:

 - **Website** - an ASP.NET 4.5 web application which serves as the primary interface to your Inedo product via a web UI and feed API implementations (for v2022 and later, this component is now part of the Service)
 - **Service** - a Windows Service that performs indexing and other background tasks
 - **Database** - an SQL Server database which contains all of the persistent data including feeds, packages(ProGet)/artifacts(BuildMaster), privileges, and internal settings

## Prerequisites

#### Pre-Installation Check List 
These are the same as the Inedo product installation guides:
[BuildMaster Installation Guide](/docs/buildmaster/installation-maintenance/buildmaster-installation-guide)
[ProGet Installation Guide](/docs/proget/installation/installation-guide)
[Otter Installation Guide](/docs/proget/installation/installation-guide)

#### Get the Manual Installation Package
The manual installation package is a .zip file that contains all the files and scripts needed to build or update the deployable components listed above.

To download the package, select the "Manual Installation" link for the desired version on the following pages:
•	[BuildMaster](https://my.inedo.com/buildmaster/versions)
•	[ProGet](https://my.inedo.com/proget/versions)
•	[Otter](https://my.inedo.com/otter/versions)

If you are unsure which version to select, use the latest version.

The manual installation package contains the following:
 - **Extensions directory** - contains the default extensions shipped with the selected version of your Inedo product.
 - **Service directory** - contains the files and binaries required to run the Windows Service for your Inedo product
 - **SqlScripts directory** - contains the SQL scripts required to generate the SQL Server database, or update an existing one to the schema required for the downloaded version
 - **Website directory** - contains the files and binaries required to run the Website application

 Note that, in earlier versions of Inedo products, the directory names may be different or .zip files instead of directories.
 
#### Installation Directories 
By default, the Inedo product installers allow you to configure their main installation directory and configure temporary directories and storage paths for packages for you. For a manual installation, these directories must be set up before installation.

Before you configure the required paths, you should decide where the following base directories should be located:

**BuildMaster:**
| Directory | Description | Installer Default |
|--|--|--|
| Root installation directory | the root disk path for the Website and Service binaries, and extensions | `C:\Program Files\BuildMaster` |
| Program data directory | the root disk path for package storage, temporary directories, and the configuration file | `C:\ProgramData\BuildMaster` |

**ProGet:**
| Directory | Description | Installer Default |
|--|--|--|
| Root installation directory | the root disk path for the Website and Service binaries, and extensions | `C:\Program Files\ProGet` |
| Program data directory | the root disk path for package storage, temporary directories, and the configuration file | `C:\ProgramData\ProGet` |

**Otter**
| Directory | Description | Installer Default |
|--|--|--|
| Root installation directory | the root disk path for the Website and Service binaries, and extensions | `C:\Program Files\Otter` |
| Program data directory | the root disk path for package storage, temporary directories, and the configuration file | `C:\ProgramData\Otter` |

Though not strictly required until later, you may also want to ensure the existence of the following directories if you would like to use the installer defaults:

**BuildMaster:**
- `C:\ProgramData\Inedo\SharedConfig`
 - `C:\Program Files\BuildMaster\Service`
 - `C:\Program Files\BuildMaster\Web`
 - `C:\Program Files\BuildMaster\Extensions`
 - `C:\ProgramData\BuildMaster\Extensions`
 - `C:\ProgramData\BuildMaster\Artifacts`
 - `C:\ProgramData\BuildMaster\ExtensionsTemp\Service`
 - `C:\ProgramData\BuildMaster\ExtensionsTemp\Web`

**ProGet:**
- `C:\ProgramData\ProGet\Extensions`
 - `C:\ProgramData\ProGet\ExtensionsTemp\Service`
 - `C:\ProgramData\ProGet\ExtensionsTemp\Web`
 - `C:\ProgramData\ProGet\Packages`
 - `C:\ProgramData\Inedo\SharedConfig`
 - `C:\Program Files\ProGet\Extensions`

:::(INFO) (ProGet)
If you plan to use other paths (i.e. UNC shares) for certain storage paths like "packages root path", you may proceed without creating the directories before they are [configured in the software](#db-settings).
:::

**Otter:**
- `C:\ProgramData\Inedo\SharedConfig`
 - `C:\Program Files\Otter\Service`
 - `C:\Program Files\Otter\Web`
 - `C:\Program Files\Otter\Extensions`
 - `C:\ProgramData\Otter\Extensions`
 - `C:\ProgramData\Otter\ExtensionsTemp\Service`
 - `C:\ProgramData\Otter\ExtensionsTemp\Web`

## Database Installation (SQL Server) 
Your Inedo product is compatible with existing supported SQL Server installations, local or remote, and also with SQL Azure. The examples here will use `osql` as the tool to execute sample queries (since it is installed with SQL Server), but you can also use `sqlcmd` or SQL Server Management Studio directly.

#### SQL Server Recommendations:
 - Use the latest version of SQL Server available (but it must be at least 2012 SP4)
 - Inedo products support SQL Server Express, but we recommend using an existing SQL Server Standard Edition (or higher) if you are licensed for it
 - If you've installed a new SQL Server instance, note whether a named or default instance is used, as it will be required for the connection string information (e.g. `Server=dbserver01\SQLEXPRESS; ...` vs. `Server=dbserver01; ...`). SQL Server Express defaults to `SQLEXPRESS` as the instance name
 - For single-server installations (i.e. non-HA/LB), you may have the database server running on the same server that ProGet is installed on (i.e., the connection string would be `Server=localhost; ...` or `Server=localhost\SQLEXPRESS; ...`)

::: (INFO) (ProGet)
For manual upgrades from a previous version installed via the ProGet installer, the instance name might be `INEDO`, and older versions (v3 and earlier) would have used the instance name `PROGET`
:::

### Prerequisites
Your Inedo product requires an existing SQL Server database server. So if you do not already have a database server, you will need to create one. We recommend installing and configuring the latest version of SQL Server Express for this purpose: [https://www.microsoft.com/en-us/sql-server/sql-server-editions-express](https://www.microsoft.com/en-us/sql-server/sql-server-editions-express).

This should mostly be a guided process, but keep in mind:
 - Windows built-in authentication is the recommended authentication mechanism (i.e., using a domain account as opposed to specifying a username/password in the connection string)
 - Be sure to add your account (or a group representing the Inedo product's database administrators) when prompted to "Specify SQL Server administrators" during the Database Engine Configuration" step so that no further steps are required to create/manage your Inedo product's database
 - Pay attention to the SQL Server instance name, as it is part of the 'Server' value in the connection string

### 1. Create a database named `«inedo-product»` on the desired SQL Server instance
Technically speaking, the database doesn't need to be named «inedo-product», but for simplicity of both upgrades and configuration, we recommend ` «inedo-product» ` as the database name. The database collation however must be `SQL_Latin1_General_CP1_CI_AS` to ensure case-insensitivity in default text comparisons.

```
osql -E -S «db-server» -Q "CREATE DATABASE [«inedo-product»] COLLATE SQL_Latin1_General_CP1_CI_AS"
```

We also recommend setting the [database recovery model](https://learn.microsoft.com/en-us/sql/relational-databases/backup-restore/recovery-models-sql-server) to Simple; this will significantly improve performance. The default (Full) model does not offer any benefit to Inedo product usage.

```
osql -E -S «db-server» -Q "ALTER DATABASE [«inedo-product»] SET RECOVERY SIMPLE"
```

### 2. Create a database server login
Since most installations will use Integrated Authentication, a database server login for the Inedo product user identity is required. If it doesn't exist, one can be created using this script:

```
osql -E -S «db-server» -Q "CREATE LOGIN [domain\«inedo-product»ServiceUser] FROM WINDOWS"
```

Note that built-in accounts may be used, such as `NT AUTHORITY\NETWORK SERVICE` or `NT AUTHORITY\LOCAL SYSTEM`, though an actual domain account is recommended.

For more information on creating database logins, see: [https://docs.microsoft.com/en-us/sql/t-sql/statements/create-login-transact-sql](https://docs.microsoft.com/en-us/sql/t-sql/statements/create-login-transact-sql)

<h3 id="update-database-schema">3. Run `inedosql` to update the database</h3>

Database updates are performed with `inedosql`, which is an open-source command-line tool developed by Inedo in order to execute SQL (.sql) scripts against a SQL Server database. See the [inedosql GitHub page](https://github.com/Inedo/inedosql) for more information.

#### Database Update Process
1. Copy the `SqlScripts` directory into a temporary directory.
2. Run command line and change current directory to the `SqlScripts` folder which contains `inedosql.exe` file.
3. Run the following command in that directory, replacing the connection string as needed:

```
.\inedosql.exe update . --connection-string=<connection-string>
```

For example, to update the ProGet DB:

```
cd C:\ProGetSetup5..14_Manual\
.\inedosql.exe update . --connection-string="Server=dbserver01\SQLEXPRESS; Database=ProGet; Integrated Security=true;"
```

This command will both update the schema of the target database and recreate all objects (views, functions, stored procedures).

::: (INFO)
On new installations, be sure to note the connection string that was used for this command, as it is a required value in the [configuration file](#first-run-file) that instructs your Inedo product which database to connect to.
::: 

#### Legacy Database Update Process
::: (INFO)
Applies to: 
* BuildMaster 6.1 and earlier
* ProGet 5.2 and earlier
* Otter 2.2 and earlier.

::: 

In older Inedo products, `dbupdater.exe` is used to update the database.  Use these instructions for updating the database:

1. Copy the `SqlScripts` directory into a temporary directory.
2. Run command line and change current directory to the `SqlScripts` folder which contains dbupdater.exe file.
3. Unpack required scripts from Scripts.gz with the following command: 
```
.\dbupdater.exe unpack .\Scripts.gz .
```
4. After the required folders/files are extracted, stay in the same directory and run the following command in that directory, replacing the connection string as needed:
```
.\dbupdater.exe update . <connection-string>
```

For example, to update a legacy ProGet installation:
```
cd C:\ProGetSetup5.2.14_Manual\
.\dbupdater.exe unpack .\Scripts.gz .
.\dbupdater.exe update . "Server=dbserver01\SQLEXPRESS; Database=ProGet; Integrated Security=true;"
```

### 4. Create a database user and grant access to your Inedo product’s database role

In order for the database server login to access the database with the permissions required by your Inedo product, a database user must be created:

```
osql -E -S «db-server» -d ProGet -Q "CREATE USER [domain\«inedo-product»ServiceUser] FOR LOGIN [domain\«inedo-product»ServiceUser]"
```

Then the user must be granted access to the Inedo product user role (which was added during the "run `dbupdater.exe`" step):

```
osql -E -S «db-server» -d ProGet -Q "ALTER ROLE [«inedo-product»User_Role] ADD MEMBER [domain\«inedo-product»ServiceUser]"
```

## Website Installation (IIS) 

### Prerequisites
Before installing any Inedo product in IIS, the following roles/features must be enabled in Windows:

#### Server Roles
 - Web Server (IIS) > Web Server > Security > Windows Authentication (*if planning to configure Integrated Windows Authentication in the future*)
 - Web Server (IIS) > Web Server > Application Development > .NET Extensibility 4.6 (or greater)
 - Web Server (IIS) > Web Server > Application Development > ASP.NET 4.6 (or greater)
 - Web Server (IIS) > Web Server > Common HTTP Features > Static Content
 - Web Server (IIS) > Management Tools > IIS Management Console

#### Features
 - .NET Framework 4.6 Features > .NET Framework 4.6
 - .NET Framework 4.6 Features > ASP.NET 4.6

#### ProGet, BuildMaster, and Otter IIS Prerequisite
You will need to download and install the appropriate Web Hosting Bundle for IIS support.

* 2022 and 2023 products will use the [.NET 6.0 Web Hosting Bundle](https://dotnet.microsoft.com/en-us/download/dotnet/thank-you/runtime-aspnetcore-6.0.6-windows-hosting-bundle-installer) 
* 2024 will use the .NET 8 Web Hosting Bundle

::: (Info) (Note:)
If the .NET SDK or Hosting Bundle was installed prior to installing IIS, you will need to repair the SDK or Hosting Bundle after you install IIS.
:::

### 1. Copy Website files
Copy the contents of the `Web` directory from the installation package to a subdirectory of the *root installation directory* identified earlier. For reference, the installer defaults this to: `C:\Program Files\«inedo-product»\Web`

:::(INFO) (This is step is not required in v2022 and later)
In Otter 2022, ProGet 2022, and BuildMsater 2022 and later, the website is now included as part of the Service directory.
:::

### 2. Create an application pool in IIS
While you could use an existing application pool if desired, we recommend creating a new one. The minimum requirements for the application pool are: 

 - **.NET CLR Version** - 4.0
 - **Managed Pipeline Mode** - Integrated is recommended, but Classic will also work

Example PowerShell command to create an app pool:
```
&"C:\Windows\System32\inetsrv\appcmd.exe" add apppool /name:«inedo-product» /managedRuntimeVersion:v4.0 /managedPipelineMode:Integrated /processModel.identityType:SpecificUser /processModel.userName:«inedo-product»ServiceUser@domain /processModel.password:<account-password>
```
You may adjust other application pool settings as desired.

### 3. Create a site in IIS 
The minimum requirements for the IIS website are:
 - **Physical Path** - the path on disk where the «inedo-product» Website files were copied to in step 1 (In ProGet 2022, you will need to point this to the Service directory)
 - **Application Pool** - the application pool to use, created in step 2
 - **Binding** - the combination of IP address(es) and port(s) used to access your Inedo product over the network

Note that any of these values can be edited once they are created, for example, to add SSL certificates, update the port that ProGet is listening on, etc.

Example PowerShell command to create a site:
```
&"C:\Windows\System32\inetsrv\appcmd.exe" add site /name:«inedo-product» /physicalPath:"C:\Program Files\«inedo-product»\Web" /bindings:"http/*:80:" /applicationDefaults.applicationPool:«inedo-product»
``` 
You may adjust other IIS site settings as desired.

## Service (Windows Service)

### 1. Copy service files 
Copy the contents of `Service` directory from the installation package to a subdirectory of the *root installation directory* identified earlier. For reference, the installer defaults this to: `C:\Program Files\«inedo-product»\Service`

### 2. Install the service
The copied service files will contain the service executable `«inedo-product».Service.exe`; run this program from an elevated command prompt or PowerShell window to install the Windows Service (eg `INEDOPROGETSVC`):

```
PS C:\Program Files\ «inedo-product»\Service> .\ «inedo-product».Service.exe install --user=" «inedo-product»ServiceUser@domain" --password="<account-password>"
```

::: (ERROR)
Note: at this time, it is not permitted to change the service name from `INEDO«inedo-product»SVC`.
:::

### 3. Start the service
The service can be started from the Windows Service Controller, or using the following PowerShell command:

```
Start-Service INEDO«inedo-product»SVC
```
## First Run 
Once the site and service are launched, your Inedo product should be accessible through the binding specified in IIS Site Step 3. The first time you access your Inedo product through the site, some additional settings will need to be configured.

### 1. Ensure the «inedo-product» configuration file exists with valid values
Once the Website, Service, and Database are configured, the final step is to create or update your Inedo product configuration file to supply the database connection string noted earlier in step 3 of the database configuration, and ensure `WebServer Enabled="false"`.

Once values in this file are changed, any IIS application pool or Windows Service that reference it must be restarted to see the new values.

### 2. Ensure the proper Advanced Configuration settings are set 
Once you log-in to your Inedo product for the first time, you can visit the *Administration* > *Advanced Settings* page to finalize the configuration stored in the database.

The following settings within the product that must be configured, their corresponding directories, and their installer defaults are listed below:

| Setting | Description | Installer Default | 
|---|---|---| 
| `Extensions.BuiltInExtensionsPath` | path containing extensions included with the installation package | `C:\Program Files\«inedo-product»\Extensions` |
| `Extensions.ExtensionsPath` | the disk path where downloaded extensions are stored and loaded from by ProGet | `C:\ProgramData\«inedo-product»\Extensions` |
| `Extensions.UseNewExtensionLoader` | when set, uses `CommonCachePath` instead of `ServiceTempPath` and `WebTempPath` for Extensions | true (checked) |
| `Extensions.CommonCachePath` | used only when `UseNewExtensionLoader` is true, a temp path where extensions loaded from `ExtensionsPath` are extracted to and loaded by the «inedo-product» service | `C:\ProgramData\«inedo-product»\ExtensionsCache` |
| `Extensions.ServiceTempPath` | used only when `UseNewExtensionLoader` is false, a temp path where extensions loaded from the extensions path are extracted to and loaded by the «inedo-product» service | `C:\ProgramData\«inedo-product»\ExtensionsTemp\Service` |
| `Extensions.WebTempPath` | used only when `UseNewExtensionLoader` is false, a temp path where extensions loaded from the extensions path are extracted to and loaded by the Inedo producr Website |  `C:\ProgramData\«inedo-product»\ExtensionsTemp\Web` |
| `Extensions.UpdateFeedUrl` | the extensions feed URL, required to browse extensions in the software | `https://proget.inedo.com/upack/Extensions` |
| `Storage.PackagesRootPath` |**ProGet Only** base path on disk for ProGet's default package store | `C:\ProgramData\ProGet\Packages` ([more info](#packages-root-path)) |
| `Artifacts.BasePath` |**BuildMaster Only** base path on disk for BuildMaster's default artifact store | `C:\ProgramData\BuildMaster\Artifacts` |


::: (ERROR)
The directories referenced in the configuration values **must** exist before you start using your Inedo software, because the Inedo product does not create them for you.

If these directories do not exist, the Diagnostic Center will log various errors related to extensions and/or the packages may be stored on disk in an undefined manner. If the directories did not exist, but your Inedo product has already been started, both the IIS application pool and the Windows service must be restarted.
::: 

Each of these directories can be assigned to a path on a local volume or UNC share provided that:
 - the user account specified as the "log on user" for the Windows Service has read/write/delete access to them
 - the user account specified as the "application pool identity" in IIS has read/write/delete access to them

We do not recommend using a mapped drive (e.g. `X:\Packages`) to reference directories for the reasons [described here](https://docs.microsoft.com/en-us/windows/win32/services/services-and-redirected-drives). Instead, use the full UNC path that the drive is mapped to, for example: `\\file-sv01\$x\packages`

::: (INFO)
If you do attempt to use a mapped drive (or you are installing on Azure using Azure Files as the backing store), you may need to configure the application pool to set the `Load User Profile` property to `True`.
:::

#### ProGet only: Packages Root Path 
The `Storage.PackagesRootPath` setting defines the base storage location on disk for packages managed by ProGet's default package store. Its value is stored in the database and assignable on the *Advanced Settings* page.

There are several other packages path settings (e.g., `Storage.NpmPackagesLibrary`, `Storage.MavenArtifactLibrary`) that are relative to the `Storage.PackagesRootPath` by default. If one of these settings is individually set, it will override the default behavior of being relative to the root path. To restore that behavior, save the desired field with an empty value.

::: (ERROR)
**Note:** Older load-balanced installations may have stored the `ProGetConfig.Storage.PackagesRootPath` storage location in a web application configuration file. This source of configuration will be removed in a future version of ProGet, replaced solely by the database setting. If you see the `ProGetConfig.Storage.PackagesRootPath` setting in an existing `Web_appSettings.config`, its value should be migrated to the `Storage.PackagesRootPath` setting in *Administration* > *Advanced Settings*. The database setting already takes precedence if it exists, so if there is an existing value for this setting on the *Advanced Settings* page, it can be removed from the configuration file.
:::

### 3. Set license key and activate
For all editions of your Inedo software you need a valid license to use it. Once the Inedo Poduct website is accessible, you will need to visit the *Administration* > *Licensing & Activation* page to apply a license key. When your Inedo product can access the Internet, the key will be activated automatically.

If you have already obtained a license key but cannot automatically activate, visit the [License Key Activation documentation](/docs/myinedo/activating-a-license-key) for more information on manual activation. 

If you do not have a license key yet (or do not know what yours is), you may view keys associated with your organization or request one from [MyInedo](https://my.inedo.com).

## Extensions 
While extensions are available in our own [public ProGet instance](https://proget.inedo.com/feeds/Extensions), the ProGet installation ships with "frozen" or "locked" versions of the extensions at the time the installer was built.

Once the `Extensions.BuiltInExtensionsPath` setting is configured to a valid directory, copy the contents of `Extensions/` directory from the installation package into that directory, then restart the application pool and Inedo product Windows Service. Any extensions in this path are combined with the extensions managed within the Inedo product (i.e. downloaded from the Administration > Extensions page and stored in the `Extensions.ExtensionsPath` directory), and the "latest" SDK-compatible version (as per semantic versioning rules) is loaded.

::: (ERROR) (Note)
The [InedoCore](https://proget.inedo.com/feeds/Extensions/inedox/InedoCore) extension must be installed to use Active Directory integration.
:::

### Manual Extension Installation

To manually install extensions, see our [manual extension installation guide](/docs/installation/manual-installation/installation-manual-extensions-installation).

## Troubleshooting

See our [troubleshooting guide](/docs/installation/manual-installation/manual-installation-troubleshooting-guide).
